/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.message.MessageStartEventSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class MessageStartEventSubscriptionStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableMessageStartEventSubscriptionState state;

    @Before
    public void setUp() {
        this.state = this.stateRule.getZeebeState().getMessageStartEventSubscriptionState();
    }

    @Test
    public void shouldExistAfterPut() {
        MessageStartEventSubscriptionRecord subscription = this.createSubscription("messageName", "startEventID", 1L);
        this.state.put(1L, subscription);
        Assertions.assertThat((boolean)this.state.exists(subscription)).isTrue();
    }

    @Test
    public void shouldNotExistForDifferentKey() {
        MessageStartEventSubscriptionRecord subscription = this.createSubscription("messageName", "startEventID", 1L);
        this.state.put(1L, subscription);
        subscription.setProcessDefinitionKey(2L);
        Assertions.assertThat((boolean)this.state.exists(subscription)).isFalse();
    }

    @Test
    public void shouldStoreSubscriptionWithKey() {
        MessageStartEventSubscriptionRecord subscription = this.createSubscription("messageName", "startEventID", 1L);
        this.state.put(1L, subscription);
        MutableReference storedSubscription = new MutableReference();
        this.state.visitSubscriptionsByMessageName(subscription.getMessageNameBuffer(), arg_0 -> ((MutableReference)storedSubscription).set(arg_0));
        Assertions.assertThat((Object)storedSubscription).isNotNull();
        Assertions.assertThat((long)((MessageStartEventSubscription)storedSubscription.get()).getKey()).isEqualTo(1L);
        Assertions.assertThat((Object)((MessageStartEventSubscription)storedSubscription.get()).getRecord()).isEqualTo((Object)subscription);
    }

    @Test
    public void shouldVisitForMessageNames() {
        MessageStartEventSubscriptionRecord subscription1 = this.createSubscription("message", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        MessageStartEventSubscriptionRecord subscription2 = this.createSubscription("message", "startEvent2", 2L);
        this.state.put(2L, subscription2);
        MessageStartEventSubscriptionRecord subscription3 = this.createSubscription("message", "startEvent3", 3L);
        this.state.put(3L, subscription3);
        MessageStartEventSubscriptionRecord subscription4 = this.createSubscription("message-other", "startEvent4", 3L);
        this.state.put(4L, subscription4);
        ArrayList visitedStartEvents = new ArrayList();
        this.state.visitSubscriptionsByMessageName(BufferUtil.wrapString((String)"message"), subscription -> visitedStartEvents.add(BufferUtil.bufferAsString((DirectBuffer)subscription.getRecord().getStartEventIdBuffer())));
        Assertions.assertThat((int)visitedStartEvents.size()).isEqualTo(3);
        Assertions.assertThat(visitedStartEvents).containsExactlyInAnyOrder((Object[])new String[]{"startEvent1", "startEvent2", "startEvent3"});
    }

    @Test
    public void shouldVisitForProcessDefinitionKey() {
        MessageStartEventSubscriptionRecord subscription1 = this.createSubscription("message1", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        MessageStartEventSubscriptionRecord subscription2 = this.createSubscription("message2", "startEvent2", 1L);
        this.state.put(2L, subscription2);
        MessageStartEventSubscriptionRecord subscription3 = this.createSubscription("message3", "startEvent3", 2L);
        this.state.put(3L, subscription3);
        ArrayList visitedSubscriptions = new ArrayList();
        this.state.visitSubscriptionsByProcessDefinition(1L, subscription -> visitedSubscriptions.add(Assertions.tuple((Object[])new Object[]{subscription.getKey(), subscription.getRecord().getMessageName()})));
        ((ListAssert)Assertions.assertThat(visitedSubscriptions).hasSize(2)).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{1L, "message1"}), Assertions.tuple((Object[])new Object[]{2L, "message2"})});
    }

    @Test
    public void shouldNotExistAfterRemove() {
        MessageStartEventSubscriptionRecord subscription1 = this.createSubscription("message1", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        MessageStartEventSubscriptionRecord subscription2 = this.createSubscription("message2", "startEvent2", 2L);
        this.state.put(2L, subscription2);
        this.state.remove(1L, BufferUtil.wrapString((String)"message1"));
        this.state.remove(2L, BufferUtil.wrapString((String)"message2"));
        Assertions.assertThat((boolean)this.state.exists(subscription1)).isFalse();
        Assertions.assertThat((boolean)this.state.exists(subscription2)).isFalse();
    }

    @Test
    public void shouldNotRemoveOtherSubscriptions() {
        MessageStartEventSubscriptionRecord subscription1 = this.createSubscription("message1", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        MessageStartEventSubscriptionRecord subscription2 = this.createSubscription("message2", "startEvent2", 1L);
        this.state.put(2L, subscription2);
        MessageStartEventSubscriptionRecord subscription3 = this.createSubscription("message1", "startEvent1", 2L);
        this.state.put(3L, subscription3);
        this.state.remove(1L, BufferUtil.wrapString((String)"message1"));
        Assertions.assertThat((boolean)this.state.exists(subscription1)).isFalse();
        Assertions.assertThat((boolean)this.state.exists(subscription2)).isTrue();
        Assertions.assertThat((boolean)this.state.exists(subscription3)).isTrue();
    }

    @Test
    public void shouldNotOverwritePreviousRecord() {
        long key = 1L;
        MessageStartEventSubscriptionRecord writtenRecord = this.createSubscription("msg", "start", 1L);
        this.state.put(1L, writtenRecord);
        writtenRecord.setMessageName(BufferUtil.wrapString((String)"foo"));
        this.state.visitSubscriptionsByMessageName(BufferUtil.wrapString((String)"msg"), readRecord -> {
            Assertions.assertThat((Comparable)readRecord.getRecord().getMessageNameBuffer()).isNotEqualTo((Object)writtenRecord.getMessageNameBuffer());
            Assertions.assertThat((Comparable)readRecord.getRecord().getMessageNameBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"msg"));
            Assertions.assertThat((Comparable)writtenRecord.getMessageNameBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"foo"));
        });
        MessageStartEventSubscriptionRecord secondSub = this.createSubscription("msg", "start", 23L);
        this.state.exists(secondSub);
        Assertions.assertThat((Comparable)writtenRecord.getMessageNameBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"foo"));
    }

    private MessageStartEventSubscriptionRecord createSubscription(String messageName, String startEventId, long key) {
        return new MessageStartEventSubscriptionRecord().setStartEventId(BufferUtil.wrapString((String)startEventId)).setMessageName(BufferUtil.wrapString((String)messageName)).setProcessDefinitionKey(key);
    }
}

