/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.migration.DbMigrationController;
import io.camunda.zeebe.engine.state.migration.DbMigrator;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DbMigrationControllerTest {
    private ReadonlyStreamProcessorContext mockContext;
    private DbMigrator mockDbMigrator;
    private DbMigrationController sutMigrationController;

    @BeforeEach
    public void setUp() {
        this.mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        this.mockDbMigrator = (DbMigrator)Mockito.mock(DbMigrator.class);
        this.sutMigrationController = new DbMigrationController((MutableZeebeState)Mockito.mock(MutableZeebeState.class), zeebeState -> this.mockDbMigrator);
    }

    @Test
    public void shouldTriggerMigrationsWhenOnRecoveredEventIsReceived() {
        this.sutMigrationController.onRecovered(this.mockContext);
        ((DbMigrator)Mockito.verify((Object)this.mockDbMigrator)).runMigrations();
    }

    @Test
    public void shouldAbortMigratorWhenOnCloseEventIsReceived() {
        CountDownLatch countdownLatch = new CountDownLatch(1);
        this.makeMigrationsMockWaitForCountDownLatch(countdownLatch);
        this.sendOnRecoveredInNewThreadAndWaitForMigrationToStart();
        this.sutMigrationController.onClose();
        countdownLatch.countDown();
        ((DbMigrator)Mockito.verify((Object)this.mockDbMigrator)).abort();
    }

    @Test
    public void shouldAbortMigratorWhenOnFailedEventIsReceived() {
        CountDownLatch countdownLatch = new CountDownLatch(1);
        this.makeMigrationsMockWaitForCountDownLatch(countdownLatch);
        this.sendOnRecoveredInNewThreadAndWaitForMigrationToStart();
        this.sutMigrationController.onFailed();
        countdownLatch.countDown();
        ((DbMigrator)Mockito.verify((Object)this.mockDbMigrator)).abort();
    }

    private void sendOnRecoveredInNewThreadAndWaitForMigrationToStart() {
        new Thread(() -> this.sutMigrationController.onRecovered(this.mockContext)).start();
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).untilAsserted(() -> ((DbMigrator)Mockito.verify((Object)this.mockDbMigrator)).runMigrations());
    }

    private void makeMigrationsMockWaitForCountDownLatch(CountDownLatch countDownLatch) {
        ((DbMigrator)Mockito.doAnswer(invocationOnMock -> {
            countDownLatch.await();
            return null;
        }).when((Object)this.mockDbMigrator)).runMigrations();
    }
}

