/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.migration.MigrationTask;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DbMigratorImplTest {
    @Test
    void shouldRunMigrationThatNeedsToBeRun() {
        MutableZeebeState mockZeebeState = (MutableZeebeState)Mockito.mock(MutableZeebeState.class);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockZeebeState, () -> Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration)).runMigration(mockZeebeState);
    }

    @Test
    void shouldNotRunMigrationThatDoesNotNeedToBeRun() {
        MutableZeebeState mockZeebeState = (MutableZeebeState)Mockito.mock(MutableZeebeState.class);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)false);
        DbMigratorImpl sut = new DbMigratorImpl(mockZeebeState, () -> Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).runMigration(mockZeebeState);
    }

    @Test
    void shouldRunMigrationsInOrder() {
        MutableZeebeState mockZeebeState = (MutableZeebeState)Mockito.mock(MutableZeebeState.class);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockZeebeState, () -> List.of(mockMigration1, mockMigration2));
        sut.runMigrations();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockMigration1, mockMigration2});
        ((MigrationTask)inOrder.verify((Object)mockMigration1)).runMigration(mockZeebeState);
        ((MigrationTask)inOrder.verify((Object)mockMigration2)).runMigration(mockZeebeState);
    }

    @Test
    void shouldNotRunAnyMigrationIfAbortSignalWasReceivedInTheVeryBeginning() {
        MutableZeebeState mockZeebeState = (MutableZeebeState)Mockito.mock(MutableZeebeState.class);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)false);
        DbMigratorImpl sut = new DbMigratorImpl(mockZeebeState, () -> Collections.singletonList(mockMigration));
        sut.abort();
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).needsToRun((ZeebeState)Mockito.any());
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).runMigration((MutableZeebeState)Mockito.any());
    }

    @Test
    void shouldNotRunSubsequentMigrationsAfterAbortSignalWasReceived() {
        MutableZeebeState mockZeebeState = (MutableZeebeState)Mockito.mock(MutableZeebeState.class);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ZeebeState)mockZeebeState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockZeebeState, () -> List.of(mockMigration1, mockMigration2));
        ((MigrationTask)Mockito.doAnswer(invocationOnMock -> {
            sut.abort();
            return null;
        }).when((Object)mockMigration1)).runMigration(mockZeebeState);
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration1)).runMigration(mockZeebeState);
        ((MigrationTask)Mockito.verify((Object)mockMigration2, (VerificationMode)Mockito.never())).runMigration(mockZeebeState);
    }
}

