/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyDbMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyDbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyMessageSubscription;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.to_1_1.TestUtilities;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import java.util.ArrayList;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ZeebeStateExtension.class})
public class DbMigrationStateTest {
    private static final long TEST_SENT_TIME = 1000L;
    private ZeebeDb<ZbColumnFamilies> zeebeDb;
    private MutableZeebeState zeebeState;
    private TransactionContext transactionContext;

    @Test
    public void testMigrateMessageSubscriptionSentTime() throws Exception {
        LegacyDbMessageSubscriptionState legacySubscriptionState = new LegacyDbMessageSubscriptionState(this.zeebeDb, this.transactionContext);
        LegacyMessageSubscription subscriptionInCorrelation = TestUtilities.createLegacyMessageSubscription(100L, 1L);
        legacySubscriptionState.put(subscriptionInCorrelation.getKey(), subscriptionInCorrelation.getRecord());
        legacySubscriptionState.updateSentTime(subscriptionInCorrelation, 1000L);
        LegacyMessageSubscription subscriptionNotInCorrelation = TestUtilities.createLegacyMessageSubscription(101L, 2L);
        legacySubscriptionState.put(subscriptionNotInCorrelation.getKey(), subscriptionNotInCorrelation.getRecord());
        this.transactionContext.getCurrentTransaction().commit();
        MutableMigrationState migrationState = this.zeebeState.getMigrationState();
        migrationState.migrateMessageSubscriptionSentTime(this.zeebeState.getMessageSubscriptionState(), this.zeebeState.getPendingMessageSubscriptionState());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.zeebeDb.isEmpty((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, this.transactionContext)).describedAs("Column family MESSAGE_SUBSCRIPTION_BY_SENT_TIME is empty", new Object[0])).isTrue();
        MutableMessageSubscriptionState subscriptionState = this.zeebeState.getMessageSubscriptionState();
        MessageSubscription migratedSubscriptionInCorrelation = this.lookupMigratedMessageSubscription(subscriptionInCorrelation, subscriptionState);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedSubscriptionInCorrelation.isCorrelating()).describedAs("Correlating flag", new Object[0])).isTrue();
        MessageSubscription migratedSubscriptionNotInCorrelation = this.lookupMigratedMessageSubscription(subscriptionNotInCorrelation, subscriptionState);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedSubscriptionNotInCorrelation.isCorrelating()).describedAs("Correlating flag", new Object[0])).isFalse();
        this.assertThaRecordIsPresentInTransientState(migratedSubscriptionInCorrelation.getRecord());
    }

    private MessageSubscription lookupMigratedMessageSubscription(LegacyMessageSubscription subscription, MutableMessageSubscriptionState subscriptionState) {
        return subscriptionState.get(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageNameBuffer());
    }

    private void assertThaRecordIsPresentInTransientState(MessageSubscriptionRecord record) {
        MutablePendingMessageSubscriptionState transientSubscriptionState = this.zeebeState.getPendingMessageSubscriptionState();
        ArrayList correlatingSubscriptions = new ArrayList();
        transientSubscriptionState.visitSubscriptionBefore(1001L, subscription -> {
            correlatingSubscriptions.add(subscription.getRecord());
            return true;
        });
        ((ListAssert)Assertions.assertThat(correlatingSubscriptions).hasSize(1)).containsExactly((Object[])new MessageSubscriptionRecord[]{record});
        transientSubscriptionState.visitSubscriptionBefore(1000L, subscription -> (Boolean)org.junit.jupiter.api.Assertions.fail((String)("Found unexpected subscription " + subscription)));
    }

    @Test
    public void testMigrateProcessMessageSubscriptionSentTime() {
        LegacyDbProcessMessageSubscriptionState legacySubscriptionState = new LegacyDbProcessMessageSubscriptionState(this.zeebeDb, this.transactionContext);
        MutableProcessMessageSubscriptionState subscriptionState = this.zeebeState.getProcessMessageSubscriptionState();
        LegacyProcessMessageSubscription openingProcessMessageSubscription = TestUtilities.createLegacyProcessMessageSubscription(100L, 1L);
        legacySubscriptionState.put(openingProcessMessageSubscription.getKey(), openingProcessMessageSubscription.getRecord(), 1000L);
        LegacyProcessMessageSubscription openedProcessMessageSubscription = TestUtilities.createLegacyProcessMessageSubscription(101L, 2L);
        legacySubscriptionState.put(openedProcessMessageSubscription.getKey(), openedProcessMessageSubscription.getRecord(), 1000L);
        legacySubscriptionState.updateToOpenedState(openedProcessMessageSubscription.getRecord());
        LegacyProcessMessageSubscription closingProcessMessageSubscription = TestUtilities.createLegacyProcessMessageSubscription(102L, 3L);
        legacySubscriptionState.put(closingProcessMessageSubscription.getKey(), closingProcessMessageSubscription.getRecord(), 1000L);
        legacySubscriptionState.updateToClosingState(closingProcessMessageSubscription.getRecord(), 1000L);
        MutableMigrationState migrationState = this.zeebeState.getMigrationState();
        migrationState.migrateProcessMessageSubscriptionSentTime(this.zeebeState.getProcessMessageSubscriptionState(), this.zeebeState.getPendingProcessMessageSubscriptionState());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.zeebeDb.isEmpty((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, this.transactionContext)).describedAs("Column family PROCESS_SUBSCRIPTION_BY_SENT_TIME is empty", new Object[0])).isTrue();
        ProcessMessageSubscription migratedOpeningSubscription = this.lookupMigratedProcessMessageSubscription(openingProcessMessageSubscription, subscriptionState);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedOpeningSubscription.isOpening()).describedAs("Opening subscription - opening flag", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedOpeningSubscription.isClosing()).describedAs("Opening subscription - closing flag", new Object[0])).isFalse();
        ProcessMessageSubscription migratedOpenedSubscription = this.lookupMigratedProcessMessageSubscription(openedProcessMessageSubscription, subscriptionState);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedOpenedSubscription.isOpening()).describedAs("Opened subscription - opening flag", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedOpenedSubscription.isClosing()).describedAs("Opened subscription - closing flag", new Object[0])).isFalse();
        ProcessMessageSubscription migratedClosingSubscription = this.lookupMigratedProcessMessageSubscription(closingProcessMessageSubscription, subscriptionState);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedClosingSubscription.isOpening()).describedAs("Closing subscription - opening flag", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)migratedClosingSubscription.isClosing()).describedAs("Closing subscription - closing flag", new Object[0])).isTrue();
        this.assertThatRecordsArePresentInTransientState(openingProcessMessageSubscription.getRecord(), closingProcessMessageSubscription.getRecord());
    }

    private void assertThatRecordsArePresentInTransientState(ProcessMessageSubscriptionRecord ... subscriptionRecords) {
        MutablePendingProcessMessageSubscriptionState transientSubscriptionState = this.zeebeState.getPendingProcessMessageSubscriptionState();
        ArrayList correlatingSubscriptions = new ArrayList();
        transientSubscriptionState.visitSubscriptionBefore(1001L, subscription -> {
            ProcessMessageSubscriptionRecord copyOfRecord = new ProcessMessageSubscriptionRecord();
            copyOfRecord.wrap(subscription.getRecord());
            correlatingSubscriptions.add(copyOfRecord);
            return true;
        });
        ((ListAssert)Assertions.assertThat(correlatingSubscriptions).hasSize(subscriptionRecords.length)).containsExactlyInAnyOrder((Object[])subscriptionRecords);
        transientSubscriptionState.visitSubscriptionBefore(1000L, subscription -> (Boolean)org.junit.jupiter.api.Assertions.fail((String)("Found unexpected subscription " + subscription)));
    }

    private ProcessMessageSubscription lookupMigratedProcessMessageSubscription(LegacyProcessMessageSubscription subscription, MutableProcessMessageSubscriptionState subscriptionState) {
        return subscriptionState.getSubscription(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageNameBuffer());
    }
}

