/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyMessageSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

final class LegacyDbMessageSubscriptionState {
    private final TransactionContext transactionContext;
    private final DbLong elementInstanceKey;
    private final DbString messageName;
    private final LegacyMessageSubscription messageSubscription;
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, LegacyMessageSubscription> subscriptionColumnFamily;
    private final DbLong sentTime;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> sentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> sentTimeColumnFamily;
    private final DbString correlationKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong> nameCorrelationAndElementInstanceKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>, DbNil> messageNameAndCorrelationKeyColumnFamily;

    LegacyDbMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        this.elementInstanceKey = new DbLong();
        this.messageName = new DbString();
        this.messageSubscription = new LegacyMessageSubscription();
        this.elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, (DbValue)this.messageSubscription);
        this.sentTime = new DbLong();
        this.sentTimeCompositeKey = new DbCompositeKey((DbKey)this.sentTime, this.elementKeyAndMessageName);
        this.sentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.correlationKey);
        this.nameCorrelationAndElementInstanceKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.elementInstanceKey);
        this.messageNameAndCorrelationKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_NAME_AND_CORRELATION_KEY, transactionContext, this.nameCorrelationAndElementInstanceKey, (DbValue)DbNil.INSTANCE);
    }

    public LegacyMessageSubscription get(long elementInstanceKey, DirectBuffer messageName) {
        this.messageName.wrapBuffer(messageName);
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        return (LegacyMessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    public void put(long key, MessageSubscriptionRecord record) {
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.messageSubscription.setKey(key).setRecord(record).setCommandSentTime(0L);
        this.subscriptionColumnFamily.upsert(this.elementKeyAndMessageName, (DbValue)this.messageSubscription);
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.upsert(this.nameCorrelationAndElementInstanceKey, (DbValue)DbNil.INSTANCE);
    }

    public void updateToCorrelatingState(MessageSubscriptionRecord record, long sentTime) {
        LegacyMessageSubscription subscription;
        long messageKey = record.getMessageKey();
        DirectBuffer messageVariables = record.getVariablesBuffer();
        if (record == this.messageSubscription.getRecord()) {
            messageVariables = BufferUtil.cloneBuffer((DirectBuffer)record.getVariablesBuffer());
        }
        if ((subscription = this.get(record.getElementInstanceKey(), record.getMessageNameBuffer())) == null) {
            throw new IllegalStateException(String.format("Expected subscription but not found. [element-instance-key: %d, message-name: %s]", record.getElementInstanceKey(), record.getMessageName()));
        }
        subscription.getRecord().setMessageKey(messageKey).setVariables(messageVariables);
        this.updateSentTime(subscription, sentTime);
    }

    public void resetSentTime(LegacyMessageSubscription subscription) {
        this.updateSentTime(subscription, 0L);
    }

    public void updateSentTimeInTransaction(LegacyMessageSubscription subscription, long sentTime) {
        this.transactionContext.runInTransaction(() -> this.updateSentTime(subscription, sentTime));
    }

    public void updateSentTime(LegacyMessageSubscription subscription, long sentTime) {
        MessageSubscriptionRecord record = subscription.getRecord();
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.removeSubscriptionFromSentTimeColumnFamily(subscription);
        subscription.setCommandSentTime(sentTime);
        this.subscriptionColumnFamily.upsert(this.elementKeyAndMessageName, (DbValue)subscription);
        if (sentTime > 0L) {
            this.sentTime.wrapLong(subscription.getCommandSentTime());
            this.sentTimeColumnFamily.upsert(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        }
    }

    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        LegacyMessageSubscription messageSubscription = (LegacyMessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
        boolean bl = found = messageSubscription != null;
        if (found) {
            this.remove(messageSubscription);
        }
        return found;
    }

    public void remove(LegacyMessageSubscription subscription) {
        this.subscriptionColumnFamily.deleteIfExists(this.elementKeyAndMessageName);
        MessageSubscriptionRecord record = subscription.getRecord();
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.deleteIfExists(this.nameCorrelationAndElementInstanceKey);
        this.removeSubscriptionFromSentTimeColumnFamily(subscription);
    }

    private void removeSubscriptionFromSentTimeColumnFamily(LegacyMessageSubscription subscription) {
        if (subscription.getCommandSentTime() > 0L) {
            this.sentTime.wrapLong(subscription.getCommandSentTime());
            this.sentTimeColumnFamily.deleteIfExists(this.sentTimeCompositeKey);
        }
    }
}

