/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.migration.ProcessMessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyDbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.to_1_1.TestUtilities;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ProcessMessageSubscriptionSentTimeMigrationTest {
    final ProcessMessageSubscriptionSentTimeMigration sutMigration = new ProcessMessageSubscriptionSentTimeMigration();

    @Nested
    @ExtendWith(value={ZeebeStateExtension.class})
    public class BlackboxTest {
        private static final long TEST_SENT_TIME = 1000L;
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableZeebeState zeebeState;
        private TransactionContext transactionContext;

        @BeforeEach
        public void setUp() {
            LegacyDbProcessMessageSubscriptionState legacySubscriptionState = new LegacyDbProcessMessageSubscriptionState(this.zeebeDb, this.transactionContext);
            MutableProcessMessageSubscriptionState subscriptionState = this.zeebeState.getProcessMessageSubscriptionState();
            LegacyProcessMessageSubscription openingProcessMessageSubscription = TestUtilities.createLegacyProcessMessageSubscription(100L, 1L);
            legacySubscriptionState.put(openingProcessMessageSubscription.getKey(), openingProcessMessageSubscription.getRecord(), 1000L);
        }

        @Test
        public void migrationNeedsToRun() {
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun((ZeebeState)this.zeebeState);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).describedAs("Migration should run", new Object[0])).isTrue();
        }

        @Test
        public void afterMigrationRunNoFurtherMigrationIsNeeded() {
            ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.runMigration(this.zeebeState);
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun((ZeebeState)this.zeebeState);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).describedAs("Migration should run", new Object[0])).isFalse();
        }
    }

    @Nested
    public class MockBasedTests {
        @Test
        public void noMigrationNeededWhenColumnIsEmpty() {
            ZeebeState mockZeebeState = (ZeebeState)Mockito.mock(ZeebeState.class);
            Mockito.when((Object)mockZeebeState.isEmpty(ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME)).thenReturn((Object)true);
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun(mockZeebeState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void migrationNeededWhenColumnIsNotEmpty() {
            ZeebeState mockZeebeState = (ZeebeState)Mockito.mock(ZeebeState.class);
            Mockito.when((Object)mockZeebeState.isEmpty(ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME)).thenReturn((Object)false);
            boolean actual = ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.needsToRun(mockZeebeState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        @Test
        public void migrationCallsMethodInMigrationState() {
            MutableZeebeState mockZeebeState = (MutableZeebeState)Mockito.mock(MutableZeebeState.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            ProcessMessageSubscriptionSentTimeMigrationTest.this.sutMigration.runMigration(mockZeebeState);
            ((MutableMigrationState)Mockito.verify((Object)mockZeebeState.getMigrationState())).migrateProcessMessageSubscriptionSentTime(mockZeebeState.getProcessMessageSubscriptionState(), mockZeebeState.getPendingProcessMessageSubscriptionState());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockZeebeState.getMigrationState()});
        }
    }
}

