/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.query;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.state.query.StateQueryService;
import io.camunda.zeebe.engine.util.Records;
import io.camunda.zeebe.engine.util.ZeebeStateExtension;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={ZeebeStateExtension.class})
final class StateQueryServiceTest {
    private StateQueryService sut;
    private ZeebeDb<ZbColumnFamilies> db;
    private MutableZeebeState state;
    private TransactionContext transactionContext;

    StateQueryServiceTest() {
    }

    @BeforeEach
    void setup() {
        this.sut = new StateQueryService(this.db);
    }

    @ParameterizedTest(name="[{index}] should throw ClosedServiceException when closed")
    @MethodSource(value={"provideOperations"})
    void shouldFailWhenServiceIsClosed(Consumer<StateQueryService> operation) {
        this.sut.close();
        Assertions.assertThatCode(() -> operation.accept(this.sut)).isInstanceOf(QueryService.ClosedServiceException.class);
    }

    private static Stream<Consumer<StateQueryService>> provideOperations() {
        return Stream.of(svc -> svc.getBpmnProcessIdForJob(1L), svc -> svc.getBpmnProcessIdForProcess(1L), svc -> svc.getBpmnProcessIdForProcessInstance(1L));
    }

    @Nested
    @DisplayName(value="getBpmnProcessIdForJob(jobKey)")
    class GetBpmnProcessIdForJob {
        GetBpmnProcessIdForJob() {
        }

        @Test
        @DisplayName(value="should return an empty optional when job is not found")
        void shouldReturnEmptyWhenNotFound() {
            long key = Protocol.encodePartitionId((int)1, (long)1L);
            Optional result = StateQueryServiceTest.this.sut.getBpmnProcessIdForJob(key);
            Assertions.assertThat((Optional)result).isEmpty();
        }

        @Test
        @DisplayName(value="should return a bpmn process id when job is found")
        void shouldReturnMatchWhenPresent() {
            String processId = "processId";
            long key = Protocol.encodePartitionId((int)1, (long)1L);
            JobRecord record = Records.job(key, "processId");
            StateQueryServiceTest.this.state.getJobState().create(key, record);
            Optional result = StateQueryServiceTest.this.sut.getBpmnProcessIdForJob(key);
            Assertions.assertThat((Optional)result).contains((Object)BufferUtil.wrapString((String)"processId"));
        }
    }

    @Nested
    @DisplayName(value="getBpmnProcessIdForProcessInstance(processInstanceKey)")
    final class GetBpmnProcessIdForProcessInstance {
        GetBpmnProcessIdForProcessInstance() {
        }

        @Test
        @DisplayName(value="should return an empty optional when process instance is not found")
        void shouldReturnEmptyWhenNotFound() {
            long key = Protocol.encodePartitionId((int)1, (long)1L);
            Optional result = StateQueryServiceTest.this.sut.getBpmnProcessIdForProcessInstance(key);
            Assertions.assertThat((Optional)result).isEmpty();
        }

        @Test
        @DisplayName(value="should return a bpmn process id when process instance is found")
        void shouldReturnMatchWhenPresent() {
            String processId = "processId";
            long key = Protocol.encodePartitionId((int)1, (long)1L);
            ProcessInstanceRecord record = Records.processInstance(key, "processId");
            StateQueryServiceTest.this.state.getElementInstanceState().newInstance(key, record, ProcessInstanceIntent.ELEMENT_ACTIVATED);
            Optional result = StateQueryServiceTest.this.sut.getBpmnProcessIdForProcessInstance(key);
            Assertions.assertThat((Optional)result).contains((Object)BufferUtil.wrapString((String)"processId"));
        }
    }

    @Nested
    @DisplayName(value="getBpmnProcessIdForProcess(processKey)")
    final class GetBpmnProcessIdForProcess {
        GetBpmnProcessIdForProcess() {
        }

        @Test
        @DisplayName(value="should return an empty optional when process is not found")
        void shouldReturnEmptyWhenNotFound() {
            long key = Protocol.encodePartitionId((int)1, (long)1L);
            Optional result = StateQueryServiceTest.this.sut.getBpmnProcessIdForProcess(key);
            Assertions.assertThat((Optional)result).isEmpty();
        }

        @Test
        @DisplayName(value="should return a bpmn process id when process is found")
        void shouldReturnMatchWhenPresent() {
            String processId = "processId";
            long key = Protocol.encodePartitionId((int)1, (long)1L);
            ProcessRecord record = Records.process(key, "processId");
            StateQueryServiceTest.this.state.getProcessState().putProcess(record.getKey(), record);
            Optional result = StateQueryServiceTest.this.sut.getBpmnProcessIdForProcess(record.getKey());
            Assertions.assertThat((Optional)result).contains((Object)BufferUtil.wrapString((String)"processId"));
        }
    }
}

