/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.signal;

import io.camunda.zeebe.engine.state.mutable.MutableSignalSubscriptionState;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class SignalSubscriptionStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableSignalSubscriptionState state;

    @Before
    public void setUp() {
        this.state = this.stateRule.getZeebeState().getSignalSubscriptionState();
    }

    @Test
    public void shouldExistAfterPut() {
        SignalSubscriptionRecord subscription = this.createSubscription("signalName", "startEventID", 1L);
        this.state.put(1L, subscription);
        Assertions.assertThat((boolean)this.state.exists(subscription)).isTrue();
    }

    @Test
    public void shouldNotExistForDifferentKey() {
        SignalSubscriptionRecord subscription = this.createSubscription("signalName", "startEventID", 1L);
        this.state.put(1L, subscription);
        subscription.setProcessDefinitionKey(2L);
        Assertions.assertThat((boolean)this.state.exists(subscription)).isFalse();
    }

    @Test
    public void shouldStoreSubscriptionWithKey() {
        SignalSubscriptionRecord subscription = this.createSubscription("signalName", "startEventID", 1L);
        this.state.put(1L, subscription);
        MutableReference storedSubscription = new MutableReference();
        this.state.visitBySignalName(subscription.getSignalNameBuffer(), arg_0 -> ((MutableReference)storedSubscription).set(arg_0));
        Assertions.assertThat((Object)storedSubscription).isNotNull();
        Assertions.assertThat((long)((SignalSubscription)storedSubscription.get()).getKey()).isEqualTo(1L);
        Assertions.assertThat((Object)((SignalSubscription)storedSubscription.get()).getRecord()).isEqualTo((Object)subscription);
    }

    @Test
    public void shouldVisitForSignalNames() {
        SignalSubscriptionRecord subscription1 = this.createSubscription("signal", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        SignalSubscriptionRecord subscription2 = this.createSubscription("signal", "startEvent2", 2L);
        this.state.put(2L, subscription2);
        SignalSubscriptionRecord subscription3 = this.createSubscription("signal", "startEvent3", 3L);
        this.state.put(3L, subscription3);
        SignalSubscriptionRecord subscription4 = this.createSubscription("signal-other", "startEvent4", 3L);
        this.state.put(4L, subscription4);
        ArrayList visitedStartEvents = new ArrayList();
        this.state.visitBySignalName(BufferUtil.wrapString((String)"signal"), subscription -> visitedStartEvents.add(BufferUtil.bufferAsString((DirectBuffer)subscription.getRecord().getCatchEventIdBuffer())));
        Assertions.assertThat((int)visitedStartEvents.size()).isEqualTo(3);
        Assertions.assertThat(visitedStartEvents).containsExactlyInAnyOrder((Object[])new String[]{"startEvent1", "startEvent2", "startEvent3"});
    }

    @Test
    public void shouldVisitForProcessDefinitionKey() {
        SignalSubscriptionRecord subscription1 = this.createSubscription("signal1", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        SignalSubscriptionRecord subscription2 = this.createSubscription("signal2", "startEvent2", 1L);
        this.state.put(2L, subscription2);
        SignalSubscriptionRecord subscription3 = this.createSubscription("signal3", "startEvent3", 2L);
        this.state.put(3L, subscription3);
        ArrayList visitedSubscriptions = new ArrayList();
        this.state.visitStartEventSubscriptionsByProcessDefinitionKey(1L, subscription -> visitedSubscriptions.add(Assertions.tuple((Object[])new Object[]{subscription.getKey(), subscription.getRecord().getSignalName()})));
        ((ListAssert)Assertions.assertThat(visitedSubscriptions).hasSize(2)).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{1L, "signal1"}), Assertions.tuple((Object[])new Object[]{2L, "signal2"})});
    }

    @Test
    public void shouldNotExistAfterRemove() {
        SignalSubscriptionRecord subscription1 = this.createSubscription("signal1", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        SignalSubscriptionRecord subscription2 = this.createSubscription("signal2", "startEvent2", 2L);
        this.state.put(2L, subscription2);
        this.state.remove(1L, BufferUtil.wrapString((String)"signal1"));
        this.state.remove(2L, BufferUtil.wrapString((String)"signal2"));
        Assertions.assertThat((boolean)this.state.exists(subscription1)).isFalse();
        Assertions.assertThat((boolean)this.state.exists(subscription2)).isFalse();
    }

    @Test
    public void shouldNotRemoveOtherSubscriptions() {
        SignalSubscriptionRecord subscription1 = this.createSubscription("signal1", "startEvent1", 1L);
        this.state.put(1L, subscription1);
        SignalSubscriptionRecord subscription2 = this.createSubscription("signal2", "startEvent2", 1L);
        this.state.put(2L, subscription2);
        SignalSubscriptionRecord subscription3 = this.createSubscription("signal1", "startEvent1", 2L);
        this.state.put(3L, subscription3);
        this.state.remove(1L, BufferUtil.wrapString((String)"signal1"));
        Assertions.assertThat((boolean)this.state.exists(subscription1)).isFalse();
        Assertions.assertThat((boolean)this.state.exists(subscription2)).isTrue();
        Assertions.assertThat((boolean)this.state.exists(subscription3)).isTrue();
    }

    @Test
    public void shouldNotOverwritePreviousRecord() {
        long key = 1L;
        SignalSubscriptionRecord writtenRecord = this.createSubscription("signal", "start", 1L);
        this.state.put(1L, writtenRecord);
        writtenRecord.setSignalName(BufferUtil.wrapString((String)"foo"));
        this.state.visitBySignalName(BufferUtil.wrapString((String)"signal"), readRecord -> {
            Assertions.assertThat((Comparable)readRecord.getRecord().getSignalNameBuffer()).isNotEqualTo((Object)writtenRecord.getSignalNameBuffer());
            Assertions.assertThat((Comparable)readRecord.getRecord().getSignalNameBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"signal"));
            Assertions.assertThat((Comparable)writtenRecord.getSignalNameBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"foo"));
        });
        SignalSubscriptionRecord secondSub = this.createSubscription("signal", "start", 23L);
        this.state.exists(secondSub);
        Assertions.assertThat((Comparable)writtenRecord.getSignalNameBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"foo"));
    }

    private SignalSubscriptionRecord createSubscription(String signalName, String startEventId, long key) {
        return new SignalSubscriptionRecord().setCatchEventId(BufferUtil.wrapString((String)startEventId)).setSignalName(BufferUtil.wrapString((String)signalName)).setProcessDefinitionKey(key);
    }
}

