/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class EngineRuleTest {
    @Rule
    public EngineRule engineRule = EngineRule.singlePartition();

    @Test
    public void commandTimestampIsControllable() {
        Instant expectedTimestamp = Instant.now().minus(Duration.ofDays(1L));
        this.engineRule.getClock().setCurrentTime(expectedTimestamp);
        Record<MessageRecordValue> message = this.engineRule.message().withName("test").withCorrelationKey("test").publish();
        this.engineRule.awaitProcessingOf(message);
        List records = RecordingExporter.getRecords();
        Assertions.assertThat((List)records).extracting(Record::getTimestamp).containsExactly((Object[])new Long[]{expectedTimestamp.toEpochMilli(), expectedTimestamp.toEpochMilli()});
    }
}

