/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.util.Records;
import io.camunda.zeebe.engine.util.TypedRecordStream;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.impl.records.CopiedRecords;
import io.camunda.zeebe.test.util.stream.StreamWrapper;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;

public final class RecordStream
extends StreamWrapper<LoggedEvent, RecordStream> {
    public RecordStream(Stream<LoggedEvent> stream) {
        super(stream);
    }

    protected RecordStream supply(Stream<LoggedEvent> wrappedStream) {
        return new RecordStream(wrappedStream);
    }

    public RecordStream withIntent(Intent intent) {
        return new RecordStream((Stream<LoggedEvent>)this.filter(r -> Records.hasIntent(r, intent)));
    }

    public TypedRecordStream<JobRecord> onlyJobRecords() {
        return new TypedRecordStream<JobRecord>(((RecordStream)this.filter(Records::isJobRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<IncidentRecord> onlyIncidentRecords() {
        return new TypedRecordStream<IncidentRecord>(((RecordStream)this.filter(Records::isIncidentRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<DeploymentRecord> onlyDeploymentRecords() {
        return new TypedRecordStream<DeploymentRecord>(((RecordStream)this.filter(Records::isDeploymentRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<ProcessInstanceRecord> onlyProcessInstanceRecords() {
        return new TypedRecordStream<ProcessInstanceRecord>(((RecordStream)this.filter(Records::isProcessInstanceRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<MessageRecord> onlyMessageRecords() {
        return new TypedRecordStream<MessageRecord>(((RecordStream)this.filter(Records::isMessageRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<MessageSubscriptionRecord> onlyMessageSubscriptionRecords() {
        return new TypedRecordStream<MessageSubscriptionRecord>(((RecordStream)this.filter(Records::isMessageSubscriptionRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<MessageStartEventSubscriptionRecord> onlyMessageStartEventSubscriptionRecords() {
        return new TypedRecordStream<MessageStartEventSubscriptionRecord>(((RecordStream)this.filter(Records::isMessageStartEventSubscriptionRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<ProcessMessageSubscriptionRecord> onlyProcessMessageSubscriptionRecords() {
        return new TypedRecordStream<ProcessMessageSubscriptionRecord>(((RecordStream)this.filter(Records::isProcessMessageSubscriptionRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<TimerRecord> onlyTimerRecords() {
        return new TypedRecordStream<TimerRecord>(((RecordStream)this.filter(Records::isTimerRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<ProcessInstanceCreationRecord> onlyProcessInstanceCreationRecords() {
        return new TypedRecordStream<ProcessInstanceCreationRecord>(((RecordStream)this.filter(Records::isProcessInstanceCreationRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public TypedRecordStream<ErrorRecord> onlyErrorRecords() {
        return new TypedRecordStream<ErrorRecord>(((RecordStream)this.filter(Records::isErrorRecord)).map(l -> CopiedRecords.createCopiedRecord((int)1, (LoggedEvent)l)));
    }

    public Stream<ProcessInstanceIntent> onlyStatesOf(String elementId) {
        DirectBuffer elementIdBuffer = BufferUtil.wrapString((String)elementId);
        return ((TypedRecordStream)this.onlyProcessInstanceRecords().onlyEvents().filter(r -> elementIdBuffer.equals(((ProcessInstanceRecord)r.getValue()).getElementIdBuffer()))).map(r -> (ProcessInstanceIntent)r.getIntent());
    }
}

