/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;

public final class RecordToWrite
implements LogAppendEntry {
    private static final long DEFAULT_KEY = 1L;
    private final RecordMetadata recordMetadata;
    private UnifiedRecordValue unifiedRecordValue;
    private long key = 1L;
    private int sourceIndex = -1;

    private RecordToWrite(RecordMetadata recordMetadata) {
        this.recordMetadata = recordMetadata;
    }

    public static RecordToWrite command() {
        RecordMetadata recordMetadata = new RecordMetadata();
        return new RecordToWrite(recordMetadata.recordType(RecordType.COMMAND));
    }

    public static RecordToWrite event() {
        RecordMetadata recordMetadata = new RecordMetadata();
        return new RecordToWrite(recordMetadata.recordType(RecordType.EVENT));
    }

    public static RecordToWrite rejection() {
        RecordMetadata recordMetadata = new RecordMetadata();
        return new RecordToWrite(recordMetadata.recordType(RecordType.COMMAND_REJECTION));
    }

    public RecordToWrite job(JobIntent intent) {
        return this.job(intent, (JobRecordValue)new JobRecord().setType("type").setRetries(3).setWorker("worker"));
    }

    public RecordToWrite jobBatch(JobBatchIntent intent) {
        this.recordMetadata.valueType(ValueType.JOB_BATCH).intent((Intent)intent);
        JobBatchRecord jobBatchRecord = new JobBatchRecord().setWorker("worker").setTimeout(10000L).setType("type").setMaxJobsToActivate(1);
        this.unifiedRecordValue = jobBatchRecord;
        return this;
    }

    public RecordToWrite job(JobIntent intent, JobRecordValue value) {
        this.recordMetadata.valueType(ValueType.JOB).intent((Intent)intent);
        this.unifiedRecordValue = (JobRecord)value;
        return this;
    }

    public RecordToWrite message(MessageIntent intent, MessageRecordValue message) {
        this.recordMetadata.valueType(ValueType.MESSAGE).intent((Intent)intent);
        this.unifiedRecordValue = (MessageRecord)message;
        return this;
    }

    public RecordToWrite processMessageSubscription(ProcessMessageSubscriptionIntent intent, ProcessMessageSubscriptionRecordValue message) {
        this.recordMetadata.valueType(ValueType.PROCESS_MESSAGE_SUBSCRIPTION).intent((Intent)intent);
        this.unifiedRecordValue = (ProcessMessageSubscriptionRecord)message;
        return this;
    }

    public RecordToWrite timer(TimerIntent intent, TimerRecordValue value) {
        this.recordMetadata.valueType(ValueType.TIMER).intent((Intent)intent);
        this.unifiedRecordValue = (TimerRecord)value;
        return this;
    }

    public RecordToWrite processInstance(ProcessInstanceIntent intent, ProcessInstanceRecordValue value) {
        this.recordMetadata.valueType(ValueType.PROCESS_INSTANCE).intent((Intent)intent);
        this.unifiedRecordValue = (ProcessInstanceRecord)value;
        return this;
    }

    public RecordToWrite variable(VariableDocumentIntent intent, VariableDocumentRecordValue value) {
        this.recordMetadata.valueType(ValueType.VARIABLE_DOCUMENT).intent((Intent)intent);
        this.unifiedRecordValue = (VariableDocumentRecord)value;
        return this;
    }

    public RecordToWrite modification(ProcessInstanceModificationRecordValue value) {
        this.recordMetadata.valueType(ValueType.PROCESS_INSTANCE_MODIFICATION).intent((Intent)ProcessInstanceModificationIntent.MODIFY);
        this.unifiedRecordValue = (ProcessInstanceModificationRecord)value;
        return this;
    }

    public RecordToWrite causedBy(int index) {
        this.sourceIndex = index;
        return this;
    }

    public RecordToWrite key(long key) {
        this.key = key;
        return this;
    }

    public long key() {
        return this.key;
    }

    public int sourceIndex() {
        return this.sourceIndex;
    }

    public RecordMetadata recordMetadata() {
        return this.recordMetadata;
    }

    public UnifiedRecordValue recordValue() {
        return this.unifiedRecordValue;
    }
}

