/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.LogStreamPrinter;
import io.camunda.zeebe.engine.util.RecordStream;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.engine.util.StreamProcessingComposite;
import io.camunda.zeebe.engine.util.TestStreams;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.util.ListLogStorage;
import io.camunda.zeebe.logstreams.util.SynchronousLogStream;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.stream.impl.StreamProcessorListener;
import io.camunda.zeebe.stream.impl.StreamProcessorMode;
import io.camunda.zeebe.test.util.AutoCloseableRule;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.allocation.DirectBufferAllocator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamProcessorRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.broker.test");
    private static final int PARTITION_ID = 0;
    private final TemporaryFolder tempFolder;
    private final AutoCloseableRule closeables = new AutoCloseableRule();
    private final ControlledActorClock clock = new ControlledActorClock();
    private final ActorSchedulerRule actorSchedulerRule = new ActorSchedulerRule((ActorClock)this.clock);
    private final ZeebeDbFactory zeebeDbFactory;
    private final int startPartitionId;
    private final int partitionCount;
    private final RuleChain chain;
    private TestStreams streams;
    private StreamProcessingComposite streamProcessingComposite;
    private ListLogStorage sharedStorage = null;
    private StreamProcessorMode streamProcessorMode = StreamProcessorMode.PROCESSING;

    public StreamProcessorRule() {
        this(new TemporaryFolder());
    }

    public StreamProcessorRule(TemporaryFolder temporaryFolder) {
        this(0, temporaryFolder);
    }

    public StreamProcessorRule(int partitionId) {
        this(partitionId, 1, DefaultZeebeDbFactory.defaultFactory(), new TemporaryFolder());
    }

    public StreamProcessorRule(int partitionId, TemporaryFolder temporaryFolder) {
        this(partitionId, 1, DefaultZeebeDbFactory.defaultFactory(), temporaryFolder);
    }

    public StreamProcessorRule(int startPartitionId, int partitionCount, ZeebeDbFactory dbFactory, ListLogStorage sharedStorage) {
        this(startPartitionId, partitionCount, dbFactory, new TemporaryFolder());
        this.sharedStorage = sharedStorage;
    }

    public StreamProcessorRule(int startPartitionId, int partitionCount, ZeebeDbFactory dbFactory, TemporaryFolder temporaryFolder) {
        this.startPartitionId = startPartitionId;
        this.partitionCount = partitionCount;
        SetupRule rule = new SetupRule(startPartitionId, partitionCount);
        this.tempFolder = temporaryFolder;
        this.zeebeDbFactory = dbFactory;
        this.chain = RuleChain.outerRule((TestRule)this.tempFolder).around((TestRule)this.actorSchedulerRule).around((TestRule)new CleanUpRule(() -> ((TemporaryFolder)this.tempFolder).getRoot())).around((TestRule)this.closeables).around((TestRule)rule);
    }

    public Statement apply(Statement base, Description description) {
        return this.chain.apply(base, description);
    }

    public StreamProcessorRule withStreamProcessorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorMode = streamProcessorMode;
        return this;
    }

    public LogStreamWriter newLogStreamWriter(int partitionId) {
        return this.streamProcessingComposite.newLogStreamWriter(partitionId);
    }

    public StreamProcessor startTypedStreamProcessor(StreamProcessingComposite.StreamProcessorTestFactory factory) {
        return this.startTypedStreamProcessor(factory, Optional.empty());
    }

    public StreamProcessor startTypedStreamProcessor(StreamProcessingComposite.StreamProcessorTestFactory factory, Optional<StreamProcessorListener> streamProcessorListenerOpt) {
        return this.streamProcessingComposite.startTypedStreamProcessor(factory, streamProcessorListenerOpt);
    }

    public StreamProcessor startTypedStreamProcessor(int partitionId, TypedRecordProcessorFactory factory, Optional<StreamProcessorListener> streamProcessorListenerOpt) {
        return this.streamProcessingComposite.startTypedStreamProcessor(partitionId, factory, streamProcessorListenerOpt);
    }

    public void pauseProcessing(int partitionId) {
        this.streamProcessingComposite.pauseProcessing(partitionId);
    }

    public void resumeProcessing(int partitionId) {
        this.streamProcessingComposite.resumeProcessing(partitionId);
    }

    public void closeStreamProcessor(int partitionId) {
        this.streamProcessingComposite.closeStreamProcessor(partitionId);
    }

    public StreamProcessor getStreamProcessor(int partitionId) {
        return this.streamProcessingComposite.getStreamProcessor(partitionId);
    }

    public SynchronousLogStream getLogStream(int partitionId) {
        return this.streamProcessingComposite.getLogStream(partitionId);
    }

    public CommandResponseWriter getCommandResponseWriter() {
        return this.streams.getMockedResponseWriter();
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }

    public MutableZeebeState getZeebeState() {
        return this.streamProcessingComposite.getZeebeState();
    }

    public RecordStream events() {
        return new RecordStream(this.streams.events(StreamProcessingComposite.getLogName(this.startPartitionId)));
    }

    public void printAllRecords() {
        int partitionId = this.startPartitionId;
        for (int i = 0; i < this.partitionCount; ++i) {
            SynchronousLogStream logStream = this.streams.getLogStream(StreamProcessingComposite.getLogName(partitionId++));
            LogStreamPrinter.printRecords(logStream);
        }
    }

    public long writeBatch(RecordToWrite ... recordToWrites) {
        return this.streamProcessingComposite.writeBatch(recordToWrites);
    }

    public long writeCommandOnPartition(int partition, Intent intent, UnifiedRecordValue value) {
        return this.streamProcessingComposite.writeCommandOnPartition(partition, intent, value);
    }

    public long writeCommandOnPartition(int partition, long key, Intent intent, UnifiedRecordValue value) {
        return this.streamProcessingComposite.writeCommandOnPartition(partition, key, intent, value);
    }

    public long writeCommand(long key, Intent intent, UnifiedRecordValue value) {
        return this.streamProcessingComposite.writeCommand(key, intent, value);
    }

    public long writeCommand(Intent intent, UnifiedRecordValue value) {
        return this.streamProcessingComposite.writeCommand(intent, value);
    }

    public long writeCommand(int requestStreamId, long requestId, Intent intent, UnifiedRecordValue value) {
        return this.streamProcessingComposite.writeCommand(requestStreamId, requestId, intent, value);
    }

    public void snapshot() {
        int partitionId = this.startPartitionId;
        this.streamProcessingComposite.snapshot(partitionId);
    }

    private class SetupRule
    extends ExternalResource {
        private final int startPartitionId;
        private final int partitionCount;

        SetupRule(int startPartitionId, int partitionCount) {
            this.startPartitionId = startPartitionId;
            this.partitionCount = partitionCount;
        }

        protected void before() {
            StreamProcessorRule.this.streams = new TestStreams(StreamProcessorRule.this.tempFolder, StreamProcessorRule.this.closeables, StreamProcessorRule.this.actorSchedulerRule.get());
            StreamProcessorRule.this.streams.withStreamProcessorMode(StreamProcessorRule.this.streamProcessorMode);
            int partitionId = this.startPartitionId;
            for (int i = 0; i < this.partitionCount; ++i) {
                if (StreamProcessorRule.this.sharedStorage != null) {
                    StreamProcessorRule.this.streams.createLogStream(StreamProcessingComposite.getLogName(partitionId), partitionId++, StreamProcessorRule.this.sharedStorage);
                    continue;
                }
                StreamProcessorRule.this.streams.createLogStream(StreamProcessingComposite.getLogName(partitionId), partitionId++);
            }
            StreamProcessorRule.this.streamProcessingComposite = new StreamProcessingComposite(StreamProcessorRule.this.streams, this.startPartitionId, StreamProcessorRule.this.zeebeDbFactory, StreamProcessorRule.this.actorSchedulerRule.get());
        }

        protected void after() {
            StreamProcessorRule.this.streams = null;
            StreamProcessorRule.this.streamProcessingComposite = null;
        }
    }

    private class CleanUpRule
    extends ExternalResource {
        private File root;
        private final Supplier<File> rootSupplier;

        CleanUpRule(Supplier<File> rootSupplier) {
            this.rootSupplier = rootSupplier;
        }

        protected void before() {
            this.root = this.rootSupplier.get();
        }

        protected void after() {
            try {
                LOG.debug("Clean up test files on path {}", (Object)this.root);
                FileUtil.deleteFolder((Path)this.root.toPath());
                long allocatedMemoryInKb = DirectBufferAllocator.getAllocatedMemoryInKb();
                if (allocatedMemoryInKb > 0L) {
                    LOG.warn("There are still allocated direct buffers of a total size of {}kB.", (Object)allocatedMemoryInKb);
                }
            }
            catch (IOException e) {
                LOG.error("Error on deleting root test folder", (Throwable)e);
            }
        }
    }
}

