/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.StreamProcessorRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class DeploymentClient {
    private static final BiFunction<Long, Consumer<Consumer<Integer>>, Record<DeploymentRecordValue>> SUCCESS_EXPECTATION = (sourceRecordPosition, forEachPartition) -> {
        Record deploymentOnPartitionOne = (Record)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withSourceRecordPosition(sourceRecordPosition.longValue())).withPartitionId(1)).getFirst();
        forEachPartition.accept(partitionId -> {
            if (partitionId == 1) {
                return;
            }
            ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withPartitionId(partitionId.intValue())).withRecordKey(deploymentOnPartitionOne.getKey())).getFirst();
        });
        ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.FULLY_DISTRIBUTED).withPartitionId(1)).withRecordKey(deploymentOnPartitionOne.getKey())).getFirst();
        return deploymentOnPartitionOne;
    };
    private static final BiFunction<Long, Consumer<Consumer<Integer>>, Record<DeploymentRecordValue>> REJECTION_EXPECTATION = (sourceRecordPosition, forEachPartition) -> (Record)((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATE).onlyCommandRejections()).withSourceRecordPosition(sourceRecordPosition.longValue())).withPartitionId(1)).getFirst();
    private static final BiFunction<Long, Consumer<Consumer<Integer>>, Record<DeploymentRecordValue>> CREATED_EXPECTATION = (sourceRecordPosition, forEachPartition) -> (Record)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withSourceRecordPosition(sourceRecordPosition.longValue())).withPartitionId(1)).getFirst();
    private final StreamProcessorRule environmentRule;
    private final DeploymentRecord deploymentRecord;
    private final Consumer<Consumer<Integer>> forEachPartition;
    private BiFunction<Long, Consumer<Consumer<Integer>>, Record<DeploymentRecordValue>> expectation = SUCCESS_EXPECTATION;

    public DeploymentClient(StreamProcessorRule environmentRule, Consumer<Consumer<Integer>> forEachPartition) {
        this.environmentRule = environmentRule;
        this.forEachPartition = forEachPartition;
        this.deploymentRecord = new DeploymentRecord();
    }

    public DeploymentClient withXmlResource(BpmnModelInstance modelInstance) {
        return this.withXmlResource("process.xml", modelInstance);
    }

    public DeploymentClient withXmlClasspathResource(String classpathResource) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InputStream resourceAsStream = this.getClass().getResourceAsStream(classpathResource);
            resourceAsStream.transferTo(outputStream);
            return this.withXmlResource(outputStream.toByteArray(), classpathResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DeploymentClient withXmlResource(byte[] resourceBytes) {
        return this.withXmlResource(resourceBytes, "process.xml");
    }

    public DeploymentClient withXmlResource(byte[] resourceBytes, String resourceName) {
        ((DeploymentResource)this.deploymentRecord.resources().add()).setResourceName(BufferUtil.wrapString((String)resourceName)).setResource((DirectBuffer)BufferUtil.wrapArray((byte[])resourceBytes));
        return this;
    }

    public DeploymentClient withXmlResource(String resourceName, BpmnModelInstance modelInstance) {
        ((DeploymentResource)this.deploymentRecord.resources().add()).setResourceName(BufferUtil.wrapString((String)resourceName)).setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance)));
        return this;
    }

    public DeploymentClient expectRejection() {
        this.expectation = REJECTION_EXPECTATION;
        return this;
    }

    public DeploymentClient expectCreated() {
        this.expectation = CREATED_EXPECTATION;
        return this;
    }

    public Record<DeploymentRecordValue> deploy() {
        long position = this.environmentRule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)this.deploymentRecord);
        return this.expectation.apply(position, this.forEachPartition);
    }
}

