/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.StreamProcessorRule;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceModificationRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.agrona.DirectBuffer;

public final class ProcessInstanceClient {
    private final StreamProcessorRule environmentRule;

    public ProcessInstanceClient(StreamProcessorRule environmentRule) {
        this.environmentRule = environmentRule;
    }

    public ProcessInstanceCreationClient ofBpmnProcessId(String bpmnProcessId) {
        return new ProcessInstanceCreationClient(this.environmentRule, bpmnProcessId);
    }

    public ExistingInstanceClient withInstanceKey(long processInstanceKey) {
        return new ExistingInstanceClient(this.environmentRule, processInstanceKey);
    }

    public static class ProcessInstanceCreationClient {
        private static final Function<Long, Record<ProcessInstanceCreationRecordValue>> SUCCESS_EXPECTATION = position -> (Record)((ProcessInstanceCreationRecordStream)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withIntent((Intent)ProcessInstanceCreationIntent.CREATED)).withSourceRecordPosition(position.longValue())).getFirst();
        private static final Function<Long, Record<ProcessInstanceCreationRecordValue>> REJECTION_EXPECTATION = position -> (Record)((ProcessInstanceCreationRecordStream)((ProcessInstanceCreationRecordStream)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).withIntent((Intent)ProcessInstanceCreationIntent.CREATE)).withSourceRecordPosition(position.longValue())).getFirst();
        private final StreamProcessorRule environmentRule;
        private final ProcessInstanceCreationRecord processInstanceCreationRecord;
        private Function<Long, Record<ProcessInstanceCreationRecordValue>> expectation = SUCCESS_EXPECTATION;

        public ProcessInstanceCreationClient(StreamProcessorRule environmentRule, String bpmnProcessId) {
            this.environmentRule = environmentRule;
            this.processInstanceCreationRecord = new ProcessInstanceCreationRecord();
            this.processInstanceCreationRecord.setBpmnProcessId(bpmnProcessId);
        }

        public ProcessInstanceCreationClient withVariables(Map<String, Object> variables) {
            this.processInstanceCreationRecord.setVariables(MsgPackUtil.asMsgPack(variables));
            return this;
        }

        public ProcessInstanceCreationClient withVariables(String variables) {
            this.processInstanceCreationRecord.setVariables(MsgPackUtil.asMsgPack((String)variables));
            return this;
        }

        public ProcessInstanceCreationClient withVariable(String key, Object value) {
            this.processInstanceCreationRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
            return this;
        }

        public ProcessInstanceCreationClient withStartInstruction(String elementId) {
            ProcessInstanceCreationStartInstruction instruction = new ProcessInstanceCreationStartInstruction().setElementId(elementId);
            this.processInstanceCreationRecord.addStartInstruction(instruction);
            return this;
        }

        public ProcessInstanceCreationWithResultClient withResult() {
            return new ProcessInstanceCreationWithResultClient(this.environmentRule, this.processInstanceCreationRecord);
        }

        public long create() {
            long position = this.environmentRule.writeCommand((Intent)ProcessInstanceCreationIntent.CREATE, (UnifiedRecordValue)this.processInstanceCreationRecord);
            Record<ProcessInstanceCreationRecordValue> resultingRecord = this.expectation.apply(position);
            return ((ProcessInstanceCreationRecordValue)resultingRecord.getValue()).getProcessInstanceKey();
        }

        public ProcessInstanceCreationClient expectRejection() {
            this.expectation = REJECTION_EXPECTATION;
            return this;
        }
    }

    public static class ExistingInstanceClient {
        public static final Function<Long, Record<ProcessInstanceRecordValue>> SUCCESS_EXPECTATION = processInstanceKey -> (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withRecordKey(processInstanceKey.longValue())).withIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED)).withProcessInstanceKey(processInstanceKey.longValue()).getFirst();
        public static final Function<Long, Record<ProcessInstanceRecordValue>> REJECTION_EXPECTATION = processInstanceKey -> (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyCommandRejections()).withIntent((Intent)ProcessInstanceIntent.CANCEL)).withRecordKey(processInstanceKey.longValue())).withProcessInstanceKey(processInstanceKey.longValue()).getFirst();
        private static final int DEFAULT_PARTITION = -1;
        private final StreamProcessorRule environmentRule;
        private final long processInstanceKey;
        private int partition = -1;
        private Function<Long, Record<ProcessInstanceRecordValue>> expectation = SUCCESS_EXPECTATION;

        public ExistingInstanceClient(StreamProcessorRule environmentRule, long processInstanceKey) {
            this.environmentRule = environmentRule;
            this.processInstanceKey = processInstanceKey;
        }

        public ExistingInstanceClient onPartition(int partition) {
            this.partition = partition;
            return this;
        }

        public ExistingInstanceClient expectRejection() {
            this.expectation = REJECTION_EXPECTATION;
            return this;
        }

        public Record<ProcessInstanceRecordValue> cancel() {
            if (this.partition == -1) {
                this.partition = ((Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).getFirst()).getPartitionId();
            }
            this.environmentRule.writeCommandOnPartition(this.partition, this.processInstanceKey, (Intent)ProcessInstanceIntent.CANCEL, (UnifiedRecordValue)new ProcessInstanceRecord().setProcessInstanceKey(this.processInstanceKey));
            return this.expectation.apply(this.processInstanceKey);
        }

        public ProcessInstanceModificationClient modification() {
            return new ProcessInstanceModificationClient(this.environmentRule, this.processInstanceKey);
        }
    }

    public static class ProcessInstanceModificationClient {
        private static final Function<Long, Record<ProcessInstanceModificationRecordValue>> SUCCESS_EXPECTATION = position -> (Record)((ProcessInstanceModificationRecordStream)((ProcessInstanceModificationRecordStream)RecordingExporter.processInstanceModificationRecords().withIntent((Intent)ProcessInstanceModificationIntent.MODIFIED)).withSourceRecordPosition(position.longValue())).getFirst();
        private static final Function<Long, Record<ProcessInstanceModificationRecordValue>> REJECTION_EXPECTATION = processInstanceKey -> (Record)((ProcessInstanceModificationRecordStream)((ProcessInstanceModificationRecordStream)((ProcessInstanceModificationRecordStream)RecordingExporter.processInstanceModificationRecords().onlyCommandRejections()).withIntent((Intent)ProcessInstanceModificationIntent.MODIFY)).withRecordKey(processInstanceKey.longValue())).withProcessInstanceKey(processInstanceKey.longValue()).getFirst();
        private Function<Long, Record<ProcessInstanceModificationRecordValue>> expectation = SUCCESS_EXPECTATION;
        private final StreamProcessorRule environmentRule;
        private final long processInstanceKey;
        private final ProcessInstanceModificationRecord record;
        private final List<ProcessInstanceModificationActivateInstruction> activateInstructions;

        public ProcessInstanceModificationClient(StreamProcessorRule environmentRule, long processInstanceKey) {
            this.environmentRule = environmentRule;
            this.processInstanceKey = processInstanceKey;
            this.record = new ProcessInstanceModificationRecord();
            this.activateInstructions = new ArrayList<ProcessInstanceModificationActivateInstruction>();
        }

        private ProcessInstanceModificationClient(StreamProcessorRule environmentRule, long processInstanceKey, ProcessInstanceModificationRecord record, List<ProcessInstanceModificationActivateInstruction> activateInstructions) {
            this.environmentRule = environmentRule;
            this.processInstanceKey = processInstanceKey;
            this.record = record;
            this.activateInstructions = activateInstructions;
        }

        public ActivationInstructionBuilder activateElement(String elementId) {
            int noAncestorScopeKey = -1;
            return this.activateElement(elementId, -1L);
        }

        public ActivationInstructionBuilder activateElement(String elementId, long ancestorScopeKey) {
            ProcessInstanceModificationActivateInstruction activateInstruction = new ProcessInstanceModificationActivateInstruction().setElementId(elementId).setAncestorScopeKey(ancestorScopeKey);
            this.activateInstructions.add(activateInstruction);
            return new ActivationInstructionBuilder(this.environmentRule, this.processInstanceKey, this.record, this.activateInstructions, activateInstruction);
        }

        public ProcessInstanceModificationClient terminateElement(long elementInstanceKey) {
            this.record.addTerminateInstruction((ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue)new ProcessInstanceModificationTerminateInstruction().setElementInstanceKey(elementInstanceKey));
            return this;
        }

        public ProcessInstanceModificationClient expectRejection() {
            this.expectation = REJECTION_EXPECTATION;
            return this;
        }

        public Record<ProcessInstanceModificationRecordValue> modify() {
            this.record.setProcessInstanceKey(this.processInstanceKey);
            this.activateInstructions.forEach(arg_0 -> ((ProcessInstanceModificationRecord)this.record).addActivateInstruction(arg_0));
            long position = this.environmentRule.writeCommand(this.processInstanceKey, (Intent)ProcessInstanceModificationIntent.MODIFY, (UnifiedRecordValue)this.record);
            if (this.expectation == REJECTION_EXPECTATION) {
                return this.expectation.apply(this.processInstanceKey);
            }
            return this.expectation.apply(position);
        }

        public static class ActivationInstructionBuilder
        extends ProcessInstanceModificationClient {
            private final ProcessInstanceModificationActivateInstruction activateInstruction;

            public ActivationInstructionBuilder(StreamProcessorRule environmentRule, long processInstanceKey, ProcessInstanceModificationRecord record, List<ProcessInstanceModificationActivateInstruction> activateInstructions, ProcessInstanceModificationActivateInstruction activateInstruction) {
                super(environmentRule, processInstanceKey, record, activateInstructions);
                this.activateInstruction = activateInstruction;
            }

            public ActivationInstructionBuilder withGlobalVariables(String variables) {
                return this.withGlobalVariables(MsgPackUtil.asMsgPack((String)variables));
            }

            public ActivationInstructionBuilder withGlobalVariables(Map<String, Object> variables) {
                return this.withGlobalVariables(MsgPackUtil.asMsgPack(variables));
            }

            public ActivationInstructionBuilder withGlobalVariables(DirectBuffer variables) {
                ProcessInstanceModificationVariableInstruction variableInstruction = new ProcessInstanceModificationVariableInstruction().setVariables(variables);
                this.activateInstruction.addVariableInstruction(variableInstruction);
                return this;
            }

            public ActivationInstructionBuilder withVariables(String variablesScopeId, String variables) {
                return this.withVariables(variablesScopeId, MsgPackUtil.asMsgPack((String)variables));
            }

            public ActivationInstructionBuilder withVariables(String variablesScopeId, Map<String, Object> variables) {
                return this.withVariables(variablesScopeId, MsgPackUtil.asMsgPack(variables));
            }

            public ActivationInstructionBuilder withVariables(String variablesScopeId, DirectBuffer variables) {
                ProcessInstanceModificationVariableInstruction variableInstruction = new ProcessInstanceModificationVariableInstruction().setElementId(variablesScopeId).setVariables(variables);
                this.activateInstruction.addVariableInstruction(variableInstruction);
                return this;
            }
        }
    }

    public static class ProcessInstanceCreationWithResultClient {
        private final StreamProcessorRule environmentRule;
        private final ProcessInstanceCreationRecord record;
        private long requestId = 1L;
        private int requestStreamId = 1;

        public ProcessInstanceCreationWithResultClient(StreamProcessorRule environmentRule, ProcessInstanceCreationRecord record) {
            this.environmentRule = environmentRule;
            this.record = record;
        }

        public ProcessInstanceCreationWithResultClient withFetchVariables(Set<String> fetchVariables) {
            ArrayProperty variablesToCollect = this.record.fetchVariables();
            fetchVariables.forEach(variable -> ((StringValue)variablesToCollect.add()).wrap(BufferUtil.wrapString((String)variable)));
            return this;
        }

        public ProcessInstanceCreationWithResultClient withRequestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        public ProcessInstanceCreationWithResultClient withRequestStreamId(int requestStreamId) {
            this.requestStreamId = requestStreamId;
            return this;
        }

        public long create() {
            long position = this.environmentRule.writeCommand(this.requestStreamId, this.requestId, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, (UnifiedRecordValue)this.record);
            return ((ProcessInstanceCreationRecordValue)((Record)((ProcessInstanceCreationRecordStream)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withIntent((Intent)ProcessInstanceCreationIntent.CREATED)).withSourceRecordPosition(position)).getFirst()).getValue()).getProcessInstanceKey();
        }

        public void asyncCreate() {
            this.environmentRule.writeCommand(this.requestStreamId, this.requestId, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, (UnifiedRecordValue)this.record);
        }
    }
}

