/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BpmnEventTypeTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    public static final String CORRELATION_KEY = "key";
    private static final List<BpmnEventTypeScenario> SCENARIOS = Arrays.asList(new BpmnEventTypeScenario("None Start Event", BpmnElementType.START_EVENT, BpmnEventType.NONE){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent(this.elementId()).done();
        }
    }, new BpmnEventTypeScenario("None Throw Event", BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnEventType.NONE){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateThrowEvent(this.elementId()).done();
        }
    }, new BpmnEventTypeScenario("None End Event", BpmnElementType.END_EVENT, BpmnEventType.NONE){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().endEvent(this.elementId()).done();
        }
    }, new BpmnEventTypeScenario("Message Start Event", BpmnElementType.START_EVENT, BpmnEventType.MESSAGE){

        @Override
        BpmnModelInstance modelInstance() {
            return ((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent(this.elementId()).message(m -> m.name(this.messageName()).zeebeCorrelationKeyExpression(BpmnEventTypeTest.CORRELATION_KEY))).endEvent().done();
        }

        @Override
        void executeInstance() {
            ENGINE.message().withName(this.messageName()).withCorrelationKey(BpmnEventTypeTest.CORRELATION_KEY).publish();
        }
    }, new BpmnEventTypeScenario("Message Catch Event", BpmnElementType.INTERMEDIATE_CATCH_EVENT, BpmnEventType.MESSAGE){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateCatchEvent(this.elementId()).message(m -> m.name(this.messageName()).zeebeCorrelationKeyExpression(BpmnEventTypeTest.CORRELATION_KEY))).endEvent().done();
        }

        @Override
        void executeInstance() {
            this.executeInstance(Collections.singletonMap(BpmnEventTypeTest.CORRELATION_KEY, BpmnEventTypeTest.CORRELATION_KEY));
            ENGINE.message().withName(this.messageName()).withCorrelationKey(BpmnEventTypeTest.CORRELATION_KEY).publish();
        }
    }, new BpmnEventTypeScenario("Message Throw Event", BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnEventType.MESSAGE){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateThrowEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateThrowEvent(this.elementId()).message(this.messageName())).zeebeJobType(this.jobType())).endEvent().done();
        }

        @Override
        void executeInstance() {
            super.executeInstance();
            Record job = (Record)((JobRecordStream)RecordingExporter.jobRecords().withElementId(this.elementId()).withIntent((Intent)JobIntent.CREATED)).getFirst();
            ENGINE.job().withKey(job.getKey()).complete();
        }
    }, new BpmnEventTypeScenario("Message End Event", BpmnElementType.END_EVENT, BpmnEventType.MESSAGE){

        @Override
        BpmnModelInstance modelInstance() {
            return ((EndEventBuilder)((EndEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().endEvent(this.elementId()).message(this.messageName())).zeebeJobType(this.jobType())).done();
        }

        @Override
        void executeInstance() {
            super.executeInstance();
            Record job = (Record)((JobRecordStream)RecordingExporter.jobRecords().withElementId(this.elementId()).withIntent((Intent)JobIntent.CREATED)).getFirst();
            ENGINE.job().withKey(job.getKey()).complete();
        }
    }, new BpmnEventTypeScenario("Timer Start Event", BpmnElementType.START_EVENT, BpmnEventType.TIMER){

        @Override
        BpmnModelInstance modelInstance() {
            return ((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent(this.elementId()).timerWithCycle("R1/PT0.01S")).endEvent().done();
        }

        @Override
        void executeInstance() {
            ENGINE.increaseTime(Duration.ofMinutes(1L));
        }
    }, new BpmnEventTypeScenario("Timer Catch Event", BpmnElementType.INTERMEDIATE_CATCH_EVENT, BpmnEventType.TIMER){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateCatchEvent(this.elementId()).timerWithDuration("PT0.01S")).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Error Start Event", BpmnElementType.START_EVENT, BpmnEventType.ERROR){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).eventSubProcess("subprocess", sp -> ((StartEventBuilder)sp.startEvent(this.elementId()).error(this.errorCode())).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType(this.jobType())).endEvent().done();
        }

        @Override
        void executeInstance() {
            long processInstanceKey = super.executeInstance(Collections.emptyMap());
            Record job = (Record)((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
            ENGINE.job().withKey(job.getKey()).withErrorCode(this.errorCode()).throwError();
        }
    }, new BpmnEventTypeScenario("Error Boundary Event", BpmnElementType.BOUNDARY_EVENT, BpmnEventType.ERROR){

        @Override
        BpmnModelInstance modelInstance() {
            return ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().serviceTask("task", t -> t.zeebeJobType(this.jobType())).boundaryEvent(this.elementId()).error(this.errorCode())).endEvent().done();
        }

        @Override
        void executeInstance() {
            long processInstanceKey = super.executeInstance(Collections.emptyMap());
            Record job = (Record)((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
            ENGINE.job().withKey(job.getKey()).withErrorCode(this.errorCode()).throwError();
        }
    }, new BpmnEventTypeScenario("Error End Event", BpmnElementType.END_EVENT, BpmnEventType.ERROR){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().subProcess("subProcess", sp -> sp.embeddedSubProcess().startEvent().endEvent(this.elementId(), e -> e.error(this.errorCode()))).boundaryEvent("boundary", b -> b.error(this.errorCode())).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Terminate End Event", BpmnElementType.END_EVENT, BpmnEventType.TERMINATE){

        @Override
        BpmnModelInstance modelInstance() {
            return ((EndEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().endEvent(this.elementId()).terminate()).done();
        }
    }, new BpmnEventTypeScenario("Link Catch Event", BpmnElementType.INTERMEDIATE_CATCH_EVENT, BpmnEventType.LINK){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateCatchEvent(this.elementId()).link("link")).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Link Throw Event", BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnEventType.LINK){

        @Override
        BpmnModelInstance modelInstance() {
            return ((IntermediateCatchEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateThrowEvent(this.elementId()).link("link")).intermediateCatchEvent().link("link")).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Receive Task", BpmnElementType.RECEIVE_TASK, BpmnEventType.MESSAGE){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().receiveTask(this.elementId(), r -> r.message(m -> m.name(this.messageName()).zeebeCorrelationKeyExpression(BpmnEventTypeTest.CORRELATION_KEY))).endEvent().done();
        }

        @Override
        void executeInstance() {
            this.executeInstance(Collections.singletonMap(BpmnEventTypeTest.CORRELATION_KEY, BpmnEventTypeTest.CORRELATION_KEY));
            ENGINE.message().withName(this.messageName()).withCorrelationKey(BpmnEventTypeTest.CORRELATION_KEY).publish();
        }
    }, new BpmnEventTypeScenario("Escalation Start Event", BpmnElementType.START_EVENT, BpmnEventType.ESCALATION){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).eventSubProcess("subprocess", sp -> ((StartEventBuilder)sp.startEvent(this.elementId()).escalation(this.escalationCode())).endEvent()).startEvent().intermediateThrowEvent("throw", i -> i.escalation(this.escalationCode())).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Escalation Throw Event", BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnEventType.ESCALATION){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateThrowEvent(this.elementId(), e -> e.escalation(this.escalationCode())).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Escalation Boundary Event", BpmnElementType.BOUNDARY_EVENT, BpmnEventType.ESCALATION){

        @Override
        BpmnModelInstance modelInstance() {
            return ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)this.processId()).startEvent().subProcess("subprocess", sp -> sp.embeddedSubProcess().startEvent().intermediateThrowEvent("throw", e -> e.escalation(this.escalationCode())).endEvent()).boundaryEvent(this.elementId(), b -> b.escalation(this.escalationCode())).cancelActivity(Boolean.valueOf(false))).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Escalation End Event", BpmnElementType.END_EVENT, BpmnEventType.ESCALATION){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().endEvent(this.elementId(), e -> e.escalation(this.escalationCode())).done();
        }
    }, new BpmnEventTypeScenario("Compensation Intermediate Throw Event", BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnEventType.COMPENSATION){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().intermediateThrowEvent(this.elementId(), t -> t.compensateEventDefinition().compensateEventDefinitionDone()).endEvent().done();
        }
    }, new BpmnEventTypeScenario("Compensation End Event", BpmnElementType.END_EVENT, BpmnEventType.COMPENSATION){

        @Override
        BpmnModelInstance modelInstance() {
            return Bpmn.createExecutableProcess((String)this.processId()).startEvent().endEvent(this.elementId(), end -> end.compensateEventDefinition().compensateEventDefinitionDone()).done();
        }
    });
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final BpmnEventTypeScenario scenario;

    public BpmnEventTypeTest(BpmnEventTypeScenario scenario) {
        this.scenario = scenario;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> scenarios() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void shouldContainEventTypeInRecord() {
        ENGINE.deployment().withXmlResource(this.scenario.modelInstance()).deploy();
        this.scenario.executeInstance();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withBpmnProcessId(this.scenario.processId()).limitToProcessInstanceCompleted().withElementId(this.scenario.elementId())).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnEventType()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.scenario.elementType, this.scenario.eventType})});
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withBpmnProcessId(this.scenario.processId()).limitToProcessInstanceCompleted().filter(r -> !this.isEvent(((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType()))).map(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnEventType())).containsOnly((Object[])new BpmnEventType[]{BpmnEventType.UNSPECIFIED});
    }

    private boolean isEvent(BpmnElementType elementType) {
        return Set.of(BpmnElementType.START_EVENT, BpmnElementType.INTERMEDIATE_CATCH_EVENT, BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnElementType.BOUNDARY_EVENT, BpmnElementType.END_EVENT, BpmnElementType.RECEIVE_TASK).contains(elementType);
    }

    private static abstract class BpmnEventTypeScenario {
        private final String name;
        private final BpmnElementType elementType;
        private final BpmnEventType eventType;
        private final String processId = Strings.newRandomValidBpmnId();
        private final String elementId = Strings.newRandomValidBpmnId();
        private final String messageName = Strings.newRandomValidBpmnId();
        private final String jobType = Strings.newRandomValidBpmnId();
        private final String errorCode = Strings.newRandomValidBpmnId();
        private final String escalationCode = Strings.newRandomValidBpmnId();

        BpmnEventTypeScenario(String name, BpmnElementType elementType, BpmnEventType eventType) {
            this.name = name;
            this.elementType = elementType;
            this.eventType = eventType;
        }

        abstract BpmnModelInstance modelInstance();

        void executeInstance() {
            ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        }

        long executeInstance(Map<String, Object> variables) {
            return ENGINE.processInstance().ofBpmnProcessId(this.processId()).withVariables(variables).create();
        }

        String processId() {
            return this.processId;
        }

        String elementId() {
            return this.elementId;
        }

        String messageName() {
            return this.messageName;
        }

        String jobType() {
            return this.jobType;
        }

        String errorCode() {
            return this.errorCode;
        }

        String escalationCode() {
            return this.escalationCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

