/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CallActivityInterruptionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().maxCommandsInBatch(1);
    private static final String PROCESS_ID_PARENT = "wf-parent";
    private static final String PROCESS_ID_CHILD = "wf-child";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private String jobType;

    @Before
    public void init() {
        this.jobType = this.helper.getJobType();
        BpmnModelInstance parentProcess = CallActivityInterruptionTest.parentProcess(AbstractBpmnModelElementBuilder::done);
        BpmnModelInstance childProcess = Bpmn.createExecutableProcess((String)PROCESS_ID_CHILD).startEvent().serviceTask("child-task", t -> t.zeebeJobType(this.jobType)).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", parentProcess).withXmlResource("wf-child.bpmn", childProcess).deploy();
    }

    @Test
    public void shouldTriggerBoundaryEventIfChildIsCompleting() {
        ENGINE.deployment().withXmlResource("parent-wf.bpmn", CallActivityInterruptionTest.parentProcess(callActivity -> ((BoundaryEventBuilder)((BoundaryEventBuilder)callActivity.boundaryEvent().cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT1M")).endEvent())).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record childTaskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        ENGINE.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)childTaskActivated.getValue()).key(childTaskActivated.getKey()), RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)timerCreated.getValue()).key(timerCreated.getKey()));
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).processInstanceRecords()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    private static BpmnModelInstance parentProcess(Consumer<CallActivityBuilder> consumer) {
        CallActivityBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID_PARENT).startEvent().callActivity("call", c -> c.zeebeProcessId(PROCESS_ID_CHILD));
        consumer.accept(builder);
        return builder.endEvent().done();
    }
}

