/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.escalation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.EscalationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class EscalationCatchEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "wf";
    private static final String THROW_ELEMENT_ID = "throw";
    private static final String ESCALATION_CODE = "ESCALATION";
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public BpmnModelInstance process;
    @Parameterized.Parameter(value=2)
    public String expectedThrowElementId;
    @Parameterized.Parameter(value=3)
    public String expectedCatchElementId;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        return new Object[][]{{"boundary event on subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).endEvent()).boundaryEvent("escalation-boundary-event", b -> b.escalation(ESCALATION_CODE)).endEvent().done(), THROW_ELEMENT_ID, "escalation-boundary-event"}, {"boundary event on multi-instance subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.multiInstance(m -> m.zeebeInputCollectionExpression("[1]"))).embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).endEvent()).boundaryEvent("escalation-boundary-event", b -> b.escalation(ESCALATION_CODE)).endEvent().done(), THROW_ELEMENT_ID, "escalation-boundary-event"}, {"escalation event subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("escalation-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent("escalation-start-event").escalation(ESCALATION_CODE)).interrupting(true)).endEvent()).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).endEvent().done(), THROW_ELEMENT_ID, "escalation-start-event"}, {"favor escalation event subprocess over boundary event on subprocess", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub", s -> s.embeddedSubProcess().eventSubProcess("escalation-event-subprocess", e -> ((StartEventBuilder)((StartEventBuilder)e.startEvent("escalation-start-event").escalation(ESCALATION_CODE)).interrupting(true)).endEvent()).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).endEvent()).boundaryEvent("escalation", b -> b.escalation(ESCALATION_CODE)).endEvent().done(), THROW_ELEMENT_ID, "escalation-start-event"}};
    }

    @Test
    public void shouldTriggerEvent() {
        ENGINE.deployment().withXmlResource(this.process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{THROW_ELEMENT_ID, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{THROW_ELEMENT_ID, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{this.expectedCatchElementId, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{this.expectedCatchElementId, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, this.expectedCatchElementId, this.expectedThrowElementId);
    }

    private void assertIsEscalated(long processInstanceKey, String catchElementId, String throwElementId) {
        Assertions.assertThat((boolean)RecordingExporter.escalationRecords((EscalationIntent)EscalationIntent.ESCALATED).withProcessInstanceKey(processInstanceKey).withCatchElementId(catchElementId).withThrowElementId(throwElementId).withEscalationCode(ESCALATION_CODE).exists()).isTrue();
    }
}

