/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.EventBasedGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessMessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class EventbasedGatewayTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final BpmnModelInstance PROCESS_WITH_TIMERS = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"PROCESS_WITH_TIMERS").startEvent("start").eventBasedGateway().id("gateway")).intermediateCatchEvent("timer-1", c -> c.timerWithDuration("PT0.1S")).sequenceFlowId("to-end1")).endEvent("end1").moveToLastGateway().intermediateCatchEvent("timer-2", c -> c.timerWithDuration("PT10S")).sequenceFlowId("to-end2")).endEvent("end2").done();
    private static final BpmnModelInstance PROCESS_WITH_EQUAL_TIMERS = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"PROCESS_WITH_EQUAL_TIMERS").startEvent("start").eventBasedGateway().id("gateway")).intermediateCatchEvent("timer-1", c -> c.timerWithDuration("PT2S")).sequenceFlowId("to-end1")).endEvent("end1").moveToLastGateway().intermediateCatchEvent("timer-2", c -> c.timerWithDuration("PT2S")).sequenceFlowId("to-end2")).endEvent("end2").done();
    private static final BpmnModelInstance PROCESS_WITH_MESSAGES = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"PROCESS_WITH_MESSAGES").startEvent("start").eventBasedGateway().id("gateway")).intermediateCatchEvent("message-1", c -> c.message(m -> m.name("msg-1").zeebeCorrelationKeyExpression("key"))).sequenceFlowId("to-end1")).endEvent("end1").moveToLastGateway().intermediateCatchEvent("message-2", c -> c.message(m -> m.name("msg-2").zeebeCorrelationKeyExpression("key"))).sequenceFlowId("to-end2")).endEvent("end2").done();
    private static final BpmnModelInstance PROCESS_WITH_TIMER_AND_MESSAGE = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"PROCESS_WITH_TIMER_AND_MESSAGE").startEvent("start").eventBasedGateway().id("gateway")).intermediateCatchEvent("timer", c -> c.timerWithDuration("PT10S")).sequenceFlowId("to-end1")).endEvent("end1").moveToLastGateway().intermediateCatchEvent("message", c -> c.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).sequenceFlowId("to-end2")).endEvent("end2").done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        ENGINE.deployment().withXmlResource(PROCESS_WITH_TIMERS).deploy();
        ENGINE.deployment().withXmlResource(PROCESS_WITH_EQUAL_TIMERS).deploy();
        ENGINE.deployment().withXmlResource(PROCESS_WITH_MESSAGES).deploy();
        ENGINE.deployment().withXmlResource(PROCESS_WITH_TIMER_AND_MESSAGE).deploy();
    }

    @Test
    public void testLifecycle() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_TIMERS").withVariable("key", "testLifecycle").create();
        Assertions.assertThat((boolean)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).exists()).isTrue();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() == BpmnElementType.EVENT_BASED_GATEWAY)).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getElementId(), r.getIntent()})).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"gateway", ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{"gateway", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"gateway", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"gateway", ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{"gateway", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"gateway", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"timer-1", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"timer-1", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"timer-1", ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{"timer-1", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"timer-1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"to-end1", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN})});
    }

    @Test
    public void shouldCreateTimer() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_TIMERS").create();
        Record gatewayEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementType(BpmnElementType.EVENT_BASED_GATEWAY).withProcessInstanceKey(processInstanceKey).getFirst();
        List timerEvents = ((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).asList();
        ((ListAssert)Assertions.assertThat((List)timerEvents).hasSize(2)).extracting(r -> Assertions.tuple((Object[])new Object[]{((TimerRecordValue)r.getValue()).getTargetElementId(), ((TimerRecordValue)r.getValue()).getElementInstanceKey()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"timer-1", gatewayEvent.getKey()}), Assertions.tuple((Object[])new Object[]{"timer-2", gatewayEvent.getKey()})});
    }

    @Test
    public void shouldOpenProcessMessageSubscriptions() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_MESSAGES").withVariable("key", "shouldOpenProcessMessageSubscriptions").create();
        Record gatewayEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementType(BpmnElementType.EVENT_BASED_GATEWAY).withProcessInstanceKey(processInstanceKey).getFirst();
        List subscriptionEvents = ((ProcessMessageSubscriptionRecordStream)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).asList();
        ((ListAssert)Assertions.assertThat((List)subscriptionEvents).hasSize(2)).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessMessageSubscriptionRecordValue)r.getValue()).getMessageName(), ((ProcessMessageSubscriptionRecordValue)r.getValue()).getElementInstanceKey()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"msg-1", gatewayEvent.getKey()}), Assertions.tuple((Object[])new Object[]{"msg-2", gatewayEvent.getKey()})});
    }

    @Test
    public void shouldContinueWhenTimerIsTriggered() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_TIMERS").withVariable("key", "shouldContinueWhenTimerIsTriggered").create();
        Assertions.assertThat((boolean)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).exists()).isTrue();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        List records = RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)records).extracting(new Function[]{Record::getIntent, r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, "timer-1"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, "to-end1"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETED, "PROCESS_WITH_TIMERS"})});
    }

    @Test
    public void shouldOnlyExecuteOneBranchWithEqualTimers() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_EQUAL_TIMERS").create();
        Assertions.assertThat((long)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).limit(2L)).count()).isEqualTo(2L);
        ENGINE.increaseTime(Duration.ofSeconds(2L));
        List timers = ((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).map(r -> ((TimerRecordValue)r.getValue()).getTargetElementId()).collect(Collectors.toList());
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withHandlerNodeId((String)timers.get(0)).withProcessInstanceKey(processInstanceKey).exists()).isTrue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).withHandlerNodeId((String)timers.get(1)).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst())).hasRejectionType(RejectionType.NOT_FOUND).hasRecordType(RecordType.COMMAND_REJECTION);
    }

    @Test
    public void shouldContinueWhenMessageIsCorrelated() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_MESSAGES").withVariable("key", "shouldContinueWhenMessageIsCorrelated").create();
        ENGINE.message().withName("msg-1").withCorrelationKey("shouldContinueWhenMessageIsCorrelated").publish();
        List records = RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)records).extracting(new Function[]{r -> r.getIntent(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, "message-1"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, "to-end1"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETED, "PROCESS_WITH_MESSAGES"})});
    }

    @Test
    public void shouldCancelTimer() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_TIMERS").withVariable("key", "shouldCancelTimer").create();
        Assertions.assertThat((boolean)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).exists()).isTrue();
        ENGINE.increaseTime(Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessInstanceKey(processInstanceKey).withHandlerNodeId("timer-2").exists()).isTrue();
    }

    @Test
    public void shouldCloseProcessMessageSubscription() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_MESSAGES").withVariable("key", "shouldCloseProcessMessageSubscription").create();
        ENGINE.message().withName("msg-1").withCorrelationKey("shouldCloseProcessMessageSubscription").publish();
        Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.DELETED).withMessageName("msg-2").withProcessInstanceKey(processInstanceKey).exists()).isTrue();
    }

    @Test
    public void shouldCancelSubscriptionsWhenScopeIsTerminated() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_TIMER_AND_MESSAGE").withVariable("key", "shouldCancelSubscriptionsWhenScopeIsTerminated").create();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).exists()).isTrue();
        Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).exists()).isTrue();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessInstanceKey(processInstanceKey).withHandlerNodeId("timer").exists()).isTrue();
        Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withMessageName("msg").exists()).isTrue();
    }

    @Test
    public void shouldOnlyExecuteOneBranchWithSimultaneousMessages() {
        ENGINE.message().withCorrelationKey("shouldOnlyExecuteOneBranchWithSimultaneousMessages").withName("msg-1").publish();
        ENGINE.message().withCorrelationKey("shouldOnlyExecuteOneBranchWithSimultaneousMessages").withName("msg-2").publish();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_MESSAGES").withVariable("key", "shouldOnlyExecuteOneBranchWithSimultaneousMessages").create();
        List messageNames = ((ProcessMessageSubscriptionRecordStream)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CORRELATE).withProcessInstanceKey(processInstanceKey).limit(2L)).map(r -> ((ProcessMessageSubscriptionRecordValue)r.getValue()).getMessageName()).collect(Collectors.toList());
        Assertions.assertThat(messageNames).hasSize(2);
        Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CORRELATED).withMessageName((String)messageNames.get(0)).exists()).isTrue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((ProcessMessageSubscriptionRecordStream)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CORRELATE).withMessageName((String)messageNames.get(1)).onlyCommandRejections()).getFirst())).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_STATE);
    }
}

