/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.DeploymentClient;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataObjectTest {
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public Function<DeploymentClient, Record<DeploymentRecordValue>> performDeployment;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"non-executable-elements", DataObjectTest.deploy("/processes/non-executable-elements.bpmn")}, {"collaboration-with-lanes", DataObjectTest.deploy("/processes/collaboration-with-lanes.bpmn")});
    }

    @Test
    public void shouldDeploymentAndExecute() {
        Record<DeploymentRecordValue> deployment = this.performDeployment.apply(this.engine.deployment());
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId("process").create();
        List processInstanceEvents = (List)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().collect(Collectors.toList());
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata()).hasSize(1);
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getBpmnElementType(), Record::getIntent}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    private static Function<DeploymentClient, Record<DeploymentRecordValue>> deploy(String resource) {
        return deploymentClient -> deploymentClient.withXmlClasspathResource(resource).deploy();
    }
}

