/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.deployment.model.validation.ZeebeTaskHeadersValidator;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ZeebeTaskHeadersValidatorTest {
    final ZeebeTaskHeadersValidator sut = new ZeebeTaskHeadersValidator();

    @Test
    public void shouldNotAddErrorAboutDuplicateKeys() {
        ValidationResultCollector mockValidationResultCollector = (ValidationResultCollector)Mockito.mock(ValidationResultCollector.class);
        ZeebeTaskHeaders element = this.creatMockTaskHeaders(List.of(new HeaderEntry("testKey", "testValue"), new HeaderEntry("testKey2", "testValue2")));
        this.sut.validate(element, mockValidationResultCollector);
        Mockito.verifyNoInteractions((Object[])new Object[]{mockValidationResultCollector});
    }

    @Test
    public void shouldAddErrorAboutDuplicateKey() {
        ValidationResultCollector mockValidationResultCollector = (ValidationResultCollector)Mockito.mock(ValidationResultCollector.class);
        ZeebeTaskHeaders element = this.creatMockTaskHeaders(List.of(new HeaderEntry("testKey", "testValue"), new HeaderEntry("testKey", "testValue")));
        this.sut.validate(element, mockValidationResultCollector);
        ((ValidationResultCollector)Mockito.verify((Object)mockValidationResultCollector)).addError(0, "Headers contain duplicate entries for key 'testKey'");
    }

    @Test
    public void shouldAddErrorsAboutMultipleDuplicateKeys() {
        ValidationResultCollector mockValidationResultCollector = (ValidationResultCollector)Mockito.mock(ValidationResultCollector.class);
        ZeebeTaskHeaders element = this.creatMockTaskHeaders(List.of(new HeaderEntry("testKey", "testValue"), new HeaderEntry("testKey", "testValue"), new HeaderEntry("testKey2", "testValue2"), new HeaderEntry("testKey3", "testValue3"), new HeaderEntry("testKey3", "testValue3")));
        this.sut.validate(element, mockValidationResultCollector);
        ((ValidationResultCollector)Mockito.verify((Object)mockValidationResultCollector)).addError(0, "Headers contain duplicate entries for key 'testKey'");
        ((ValidationResultCollector)Mockito.verify((Object)mockValidationResultCollector)).addError(0, "Headers contain duplicate entries for key 'testKey3'");
        ((ValidationResultCollector)Mockito.verify((Object)mockValidationResultCollector, (VerificationMode)Mockito.never())).addError(0, "Headers contain duplicate entries for key 'testKey2'");
    }

    private ZeebeTaskHeaders creatMockTaskHeaders(Collection<HeaderEntry> headers) {
        ZeebeTaskHeaders mock = (ZeebeTaskHeaders)Mockito.mock(ZeebeTaskHeaders.class);
        Collection taskHeaders = headers.stream().map(this::createMockTestHeader).collect(Collectors.toList());
        Mockito.when((Object)mock.getHeaders()).thenReturn((Object)taskHeaders);
        return mock;
    }

    private ZeebeHeader createMockTestHeader(HeaderEntry headerEntry) {
        ZeebeHeader mock = (ZeebeHeader)Mockito.mock(ZeebeHeader.class);
        Mockito.when((Object)mock.getKey()).thenReturn((Object)headerEntry.key());
        Mockito.when((Object)mock.getValue()).thenReturn((Object)headerEntry.value());
        return mock;
    }

    private record HeaderEntry(String key, String value) {
    }
}

