/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.DeploymentClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstances;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OutputMappingIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "processId";
    private static final String OUTPUT_SOURCE_EXPRESSION = "assert(foo, foo != null)";
    @Parameterized.Parameter
    public String description;
    @Parameterized.Parameter(value=1)
    public DeploymentClient deployment;
    @Parameterized.Parameter(value=2)
    public String elementId;
    @Parameterized.Parameter(value=3)
    public boolean createsJob;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"Service task", ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("serviceTaskId", b -> ((ServiceTaskBuilder)b.zeebeJobType("type")).zeebeOutputExpression(OUTPUT_SOURCE_EXPRESSION, "bar")).endEvent().done()), "serviceTaskId", true}, {"Intermediate throw event", ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent("intermediateThrowEventId", b -> b.zeebeOutputExpression(OUTPUT_SOURCE_EXPRESSION, "bar")).endEvent().done()), "intermediateThrowEventId", false}, {"Business rule task", ENGINE.deployment().withXmlClasspathResource("/dmn/drg-force-user.dmn").withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask("businessRuleTaskId", b -> ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId("jedi_or_sith")).zeebeResultVariable("result")).zeebeInputExpression("\"blue\"", "lightsaberColor")).zeebeOutputExpression(OUTPUT_SOURCE_EXPRESSION, "bar")).endEvent().done()), "businessRuleTaskId", false}, {"None end event", ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("endEventId", b -> b.zeebeOutputExpression(OUTPUT_SOURCE_EXPRESSION, "bar")).done()), "endEventId", false});
    }

    @Test
    public void shouldCreateIncidentOnOutputMappingFailure() {
        this.deployment.deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        if (this.createsJob) {
            ENGINE.job().withType("type").ofInstance(processInstanceKey).complete();
        }
        Record failureCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId(this.elementId).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETING)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        Assertions.assertThat((long)incidentEvent.getKey()).isGreaterThan(0L);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasElementId(this.elementId).hasElementInstanceKey(failureCommand.getKey()).hasTenantId("<default>").hasVariableScopeKey(failureCommand.getKey());
        Assertions.assertThat((String)((IncidentRecordValue)incidentEvent.getValue()).getErrorMessage()).contains(new CharSequence[]{"Assertion failure on evaluate the expression"});
    }

    @Test
    public void shouldResolveIncidentForOutputMappingFailure() {
        this.deployment.deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        if (this.createsJob) {
            ENGINE.job().withType("type").ofInstance(processInstanceKey).complete();
        }
        Record incidentRecord = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Map.entry("foo", 1)})).update();
        Record<IncidentRecordValue> resolvedIncidentRecord = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentRecord.getKey()).resolve();
        Assertions.assertThat((long)resolvedIncidentRecord.getKey()).isEqualTo(incidentRecord.getKey());
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)resolvedIncidentRecord.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasElementId(this.elementId);
        Assertions.assertThat((String)((IncidentRecordValue)resolvedIncidentRecord.getValue()).getErrorMessage()).contains(new CharSequence[]{"Assertion failure on evaluate the expression"});
        Assert.assertTrue((boolean)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).exists());
        Map variables = ProcessInstances.getCurrentVariables((long)processInstanceKey);
        Assertions.assertThat((Map)variables).contains(new Map.Entry[]{Map.entry("foo", "1")});
        Assertions.assertThat((Map)variables).contains(new Map.Entry[]{Map.entry("bar", "1")});
    }

    @Test
    public void shouldResolveIncidentIfProcessCancelled() {
        this.deployment.deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        if (this.createsJob) {
            ENGINE.job().withType("type").ofInstance(processInstanceKey).complete();
        }
        Record incidentRecord = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record resolvedIncidentRecord = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)IncidentIntent.RESOLVED)).getFirst();
        Assertions.assertThat((long)incidentRecord.getKey()).isEqualTo(resolvedIncidentRecord.getKey());
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)resolvedIncidentRecord.getValue())).hasErrorType(ErrorType.IO_MAPPING_ERROR).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasElementId(this.elementId);
        Assertions.assertThat((String)((IncidentRecordValue)resolvedIncidentRecord.getValue()).getErrorMessage()).contains(new CharSequence[]{"Assertion failure on evaluate the expression"});
        Assert.assertTrue((boolean)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).withIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED)).exists());
    }
}

