/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class YieldJobTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static String jobType;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Before
    public void setup() {
        jobType = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldYield() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        Record<JobRecordValue> yieldRecord = ENGINE.job().withKey(jobKey).withType(jobType).ofInstance(job.getProcessInstanceKey()).yield();
        Assertions.assertThat(yieldRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.YIELDED);
        Assertions.assertThat((JobRecordValue)((JobRecordValue)yieldRecord.getValue())).hasWorker(job.getWorker()).hasType(job.getType());
    }

    @Test
    public void shouldRejectYieldIfJobNotActivated() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).fail();
        Record<JobRecordValue> yieldRecord = ENGINE.job().withKey(jobKey).ofInstance(job.getProcessInstanceKey()).expectRejection().yield();
        Assertions.assertThat(yieldRecord).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to yield job with key '%d', but it is in state '%s'", jobKey, JobState.State.FAILED));
    }
}

