/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class TenantAwareProcessInstanceVariableTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    public static final String PROCESS_ID = "process";
    private static final String TENANT_ID = "foo";
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done();
    private long processDefinitionKey;

    @Before
    public void init() {
        this.processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(PROCESS).withTenantId(TENANT_ID).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    @Test
    public void shouldAssignTenantOnVariableCreation() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").withTenantId(TENANT_ID).create();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey).hasProcessDefinitionKey(this.processDefinitionKey).hasTenantId(TENANT_ID).hasName("x").hasValue("1");
    }

    @Test
    public void shouldAssignTenantOnVariableUpdate() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").withTenantId(TENANT_ID).create();
        ENGINE_RULE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)2)})).forAuthorizedTenants(TENANT_ID).update();
        Record variableUpdated = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableUpdated.getValue())).hasScopeKey(processInstanceKey).hasProcessDefinitionKey(this.processDefinitionKey).hasTenantId(TENANT_ID).hasName("x").hasValue("2");
    }
}

