/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class SignalIntermediateThrowEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String SIGNAL_NAME_1 = "signalName";
    private static final String PROCESS = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldBroadcastSignalIntermediateThrowEvent() {
        BpmnModelInstance process = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent("start").intermediateThrowEvent("signal_throw_event").signal(SIGNAL_NAME_1)).endEvent("end").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS).create();
        Record processInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).filterRootScope().getFirst();
        Record throwEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.INTERMEDIATE_THROW_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)throwEvent.getValue())).hasProcessDefinitionKey(((ProcessInstanceRecordValue)processInstance.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(PROCESS).hasVersion(((ProcessInstanceRecordValue)processInstance.getValue()).getVersion()).hasProcessInstanceKey(processInstance.getKey()).hasBpmnEventType(BpmnEventType.SIGNAL).hasElementId("signal_throw_event").hasFlowScopeKey(processInstance.getKey());
        Record signalRecord = (Record)RecordingExporter.signalRecords((SignalIntent)SignalIntent.BROADCASTED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalRecordValue)((SignalRecordValue)signalRecord.getValue())).hasSignalName(SIGNAL_NAME_1);
    }

    @Test
    public void shouldApplyInputMappings() {
        BpmnModelInstance process = ((IntermediateThrowEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent().intermediateThrowEvent("signal_throw_event").zeebeInputExpression("x", "y")).signal(SIGNAL_NAME_1)).endEvent("end").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS).withVariables(Map.of("x", 1, "y", 2)).create();
        long flowScopeKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("signal_throw_event").getFirst()).getKey();
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withScopeKey(flowScopeKey).limit(1L)).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getName, VariableRecordValue::getValue}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"y", "1"})});
        Record signalRecord = (Record)RecordingExporter.signalRecords((SignalIntent)SignalIntent.BROADCASTED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalRecordValue)((SignalRecordValue)signalRecord.getValue())).hasSignalName(SIGNAL_NAME_1).hasVariables(Map.of("y", 1));
    }

    @Test
    public void shouldApplyOutputMappings() {
        BpmnModelInstance process = ((IntermediateThrowEventBuilder)((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)PROCESS).startEvent().intermediateThrowEvent("signal_throw_event").zeebeOutputExpression("x", "y")).signal(SIGNAL_NAME_1)).endEvent("end").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS).withVariables(Map.of("x", 1, "y", 2)).create();
        long throwEventActivatePosition = ((Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("signal_throw_event").limit(1L)).getFirst()).getPosition();
        Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > throwEventActivatePosition)).withScopeKey(processInstanceKey).limit(1L)).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getName, VariableRecordValue::getValue}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"y", "1"})});
        Record signalRecord = (Record)RecordingExporter.signalRecords((SignalIntent)SignalIntent.BROADCASTED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalRecordValue)((SignalRecordValue)signalRecord.getValue())).hasSignalName(SIGNAL_NAME_1);
    }
}

