/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Consumer;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ClaimUserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance process() {
        return ClaimUserTaskTest.process(b -> {});
    }

    private static BpmnModelInstance process(Consumer<UserTaskBuilder> consumer) {
        UserTaskBuilder builder = (UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task").zeebeUserTask();
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Test
    public void shouldEmitAssigningEventForClaimedUserTask() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().withKey(userTaskKey).withAssignee("foo").claim();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)claimedRecord.getValue();
        Assertions.assertThat(claimedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        Assertions.assertThat((UserTaskRecordValue)recordValue).hasUserTaskKey(userTaskKey).hasTenantId("<default>");
    }

    @Test
    public void shouldClaimUserTaskForAssignee() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAssignee("foo").claim();
        Assertions.assertThat(claimedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)claimedRecord.getValue())).hasAssignee("foo");
    }

    @Test
    public void shouldRejectClaimUserTaskForEmptyAssignee() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAssignee("").expectRejection().claim();
        Assertions.assertThat(claimedRecord).hasRejectionType(RejectionType.INVALID_STATE);
    }

    @Test
    public void shouldRejectClaimIfUserTaskNotFound() {
        int key = 123;
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().withKey(123L).withAssignee("foo").expectRejection().claim();
        Assertions.assertThat(claimedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectUserTaskWithAssigneeAlreadyAssigned() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process(b -> b.zeebeAssignee("foo"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().withKey(userTaskKey).withAssignee("new assignee").expectRejection().claim();
        Assertions.assertThat(claimedRecord).hasRejectionType(RejectionType.INVALID_STATE);
    }

    @Test
    public void shouldRejectUserTaskWithEmptyAssigneeWhenAlreadyAssigned() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process(b -> b.zeebeAssignee("foo"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().withKey(userTaskKey).withAssignee("").expectRejection().claim();
        Assertions.assertThat(claimedRecord).hasRejectionType(RejectionType.INVALID_STATE);
    }

    @Test
    public void shouldClaimUserTaskWithAssigneeSelf() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process(b -> b.zeebeAssignee("foo"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().withKey(userTaskKey).withAssignee("foo").claim();
        Assertions.assertThat(claimedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)claimedRecord.getValue())).hasAssignee("foo");
    }

    @Test
    public void shouldRejectClaimIfUserTaskIsCompleted() {
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).complete();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().ofInstance(processInstanceKey).expectRejection().claim();
        Assertions.assertThat(claimedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldClaimUserTaskForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("acme").withAssignee("foo").claim();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)claimedRecord.getValue();
        Assertions.assertThat(claimedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        Assertions.assertThat((UserTaskRecordValue)recordValue).hasTenantId("acme");
    }

    @Test
    public void shouldRejectClaimIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.deployment().withXmlResource(ClaimUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> claimedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("foo").expectRejection().claim();
        Assertions.assertThat(claimedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

