/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class EventAppliersTest {
    private EventAppliers eventAppliers;
    @Mock
    private TypedEventApplier<Intent, ? extends RecordValue> mockedApplier;
    @Mock
    private TypedEventApplier<Intent, ? extends RecordValue> anotherMockedApplier;

    @BeforeEach
    void setup() {
        this.eventAppliers = new EventAppliers();
    }

    @Test
    void shouldApplyStateUsingRegisteredApplier() {
        this.eventAppliers.register(Intent.UNKNOWN, 1, this.mockedApplier);
        this.eventAppliers.applyState(1L, Intent.UNKNOWN, null, 1);
        ((TypedEventApplier)Mockito.verify(this.mockedApplier)).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldNotApplyStateUsingUnregisteredApplier() {
        this.eventAppliers.applyState(1L, Intent.UNKNOWN, null, 1);
        ((TypedEventApplier)Mockito.verify(this.mockedApplier, (VerificationMode)Mockito.never())).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldNotApplyStateUsingRegisteredApplierForOlderVersion() {
        this.eventAppliers.register(Intent.UNKNOWN, 1, this.mockedApplier);
        this.eventAppliers.applyState(1L, Intent.UNKNOWN, null, 2);
        ((TypedEventApplier)Mockito.verify(this.mockedApplier, (VerificationMode)Mockito.never())).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldApplyStateUsingRegisteredApplierForSpecificVersion() {
        this.eventAppliers.register(Intent.UNKNOWN, 1, this.mockedApplier);
        this.eventAppliers.register(Intent.UNKNOWN, 2, this.anotherMockedApplier);
        this.eventAppliers.applyState(1L, Intent.UNKNOWN, null, 2);
        ((TypedEventApplier)Mockito.verify(this.mockedApplier, (VerificationMode)Mockito.never())).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
        ((TypedEventApplier)Mockito.verify(this.anotherMockedApplier)).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldGetLatestVersionOfOnlyRegisteredVersion() {
        boolean expectedVersion = true;
        this.eventAppliers.register(Intent.UNKNOWN, 1, this.mockedApplier);
        int actualVersion = this.eventAppliers.getLatestVersion(Intent.UNKNOWN);
        Assertions.assertEquals((int)1, (int)actualVersion);
    }

    @Test
    void shouldGetLatestVersionOfTwoRegisteredVersions() {
        int expectedVersion = 2;
        this.eventAppliers.register(Intent.UNKNOWN, 1, this.mockedApplier);
        this.eventAppliers.register(Intent.UNKNOWN, 2, this.mockedApplier);
        int actualVersion = this.eventAppliers.getLatestVersion(Intent.UNKNOWN);
        Assertions.assertEquals((int)2, (int)actualVersion);
    }

    @Test
    void shouldGetLatestVersionMinusOneWhenNoRegisteredVersion() {
        int expectedVersion = -1;
        int actualVersion = this.eventAppliers.getLatestVersion(Intent.UNKNOWN);
        Assertions.assertEquals((int)-1, (int)actualVersion);
    }

    @Test
    void shouldGetLatestVersionWhenMultipleRegisteredEventAppliersWithDifferentIntents() {
        boolean expectedVersion = true;
        this.eventAppliers.register(Intent.UNKNOWN, 1, this.mockedApplier);
        this.eventAppliers.register((Intent)ProcessIntent.CREATED, 1, this.mockedApplier);
        int actualVersion = this.eventAppliers.getLatestVersion(Intent.UNKNOWN);
        Assertions.assertEquals((int)1, (int)actualVersion);
    }
}

