/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProcessStateMultiTenantTest {
    private static final String TENANT_1 = "tenant1";
    private static final String TENANT_2 = "tenant2";
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableProcessState processState;
    private MutableProcessingState processingState;
    private KeyGenerator keyGenerator;

    @Before
    public void setUp() {
        this.processingState = this.stateRule.getProcessingState();
        this.processState = this.processingState.getProcessState();
        this.keyGenerator = this.processingState.getKeyGenerator();
    }

    @Test
    public void shouldPutDeploymentForDifferentTenants() {
        long processKey = this.keyGenerator.nextKey();
        String processId = Strings.newRandomValidBpmnId();
        boolean version = true;
        DeploymentRecord tenant1Deployment = this.createDeploymentRecord(TENANT_1, processKey, processId, 1);
        DeploymentRecord tenant2Deployment = this.createDeploymentRecord(TENANT_2, processKey, processId, 1);
        this.processState.putDeployment(tenant1Deployment);
        this.processState.putDeployment(tenant2Deployment);
        DeployedProcess tenant1DeployedProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_1);
        this.assertDeployedProcess(tenant1DeployedProcess, TENANT_1, processKey, processId, 1);
        DeployedProcess tenant2DeployedProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_2);
        this.assertDeployedProcess(tenant2DeployedProcess, TENANT_2, processKey, processId, 1);
        tenant1DeployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 1, TENANT_1);
        this.assertDeployedProcess(tenant1DeployedProcess, TENANT_1, processKey, processId, 1);
        tenant2DeployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 1, TENANT_2);
        this.assertDeployedProcess(tenant2DeployedProcess, TENANT_2, processKey, processId, 1);
        tenant1DeployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)processId), TENANT_1);
        this.assertDeployedProcess(tenant1DeployedProcess, TENANT_1, processKey, processId, 1);
        tenant2DeployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)processId), TENANT_2);
        this.assertDeployedProcess(tenant2DeployedProcess, TENANT_2, processKey, processId, 1);
    }

    @Test
    public void shouldPutProcessForMultipleTenants() {
        long processKey = this.keyGenerator.nextKey();
        String processId = Strings.newRandomValidBpmnId();
        boolean version = true;
        ProcessRecord tenant1Process = ProcessStateMultiTenantTest.createProcessRecord(TENANT_1, processKey, processId, 1);
        ProcessRecord tenant2Process = ProcessStateMultiTenantTest.createProcessRecord(TENANT_2, processKey, processId, 1);
        this.processState.putProcess(processKey, tenant1Process);
        this.processState.putProcess(processKey, tenant2Process);
        DeployedProcess tenant1DeployedProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_1);
        this.assertDeployedProcess(tenant1DeployedProcess, TENANT_1, processKey, processId, 1);
        DeployedProcess tenant2DeployedProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_2);
        this.assertDeployedProcess(tenant2DeployedProcess, TENANT_2, processKey, processId, 1);
        tenant1DeployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 1, TENANT_1);
        this.assertDeployedProcess(tenant1DeployedProcess, TENANT_1, processKey, processId, 1);
        tenant2DeployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 1, TENANT_2);
        this.assertDeployedProcess(tenant2DeployedProcess, TENANT_2, processKey, processId, 1);
        tenant1DeployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)processId), TENANT_1);
        this.assertDeployedProcess(tenant1DeployedProcess, TENANT_1, processKey, processId, 1);
        tenant2DeployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)processId), TENANT_2);
        this.assertDeployedProcess(tenant2DeployedProcess, TENANT_2, processKey, processId, 1);
        Assertions.assertThat((Comparable)tenant1Process.getChecksumBuffer()).isNotEqualTo((Object)tenant2Process.getChecksumBuffer());
        Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)processId), TENANT_1)).isEqualTo((Object)tenant1Process.getChecksumBuffer());
        Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)processId), TENANT_2)).isEqualTo((Object)tenant2Process.getChecksumBuffer());
        Assertions.assertThat((int)this.processState.getLatestProcessVersion(processId, TENANT_1)).isEqualTo(1);
        Assertions.assertThat((int)this.processState.getLatestProcessVersion(processId, TENANT_2)).isEqualTo(1);
        Assertions.assertThat((int)this.processState.getNextProcessVersion(processId, TENANT_1)).isEqualTo(2);
        Assertions.assertThat((int)this.processState.getNextProcessVersion(processId, TENANT_2)).isEqualTo(2);
    }

    @Test
    public void shouldUpdateProcessStateForTenant() {
        long processKey = this.keyGenerator.nextKey();
        String processId = Strings.newRandomValidBpmnId();
        boolean version = true;
        ProcessRecord tenant1Process = ProcessStateMultiTenantTest.createProcessRecord(TENANT_1, processKey, processId, 1);
        ProcessRecord tenant2Process = ProcessStateMultiTenantTest.createProcessRecord(TENANT_2, processKey, processId, 1);
        this.processState.putProcess(processKey, tenant1Process);
        this.processState.putProcess(processKey, tenant2Process);
        DeployedProcess tenant1InitialProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_1);
        DeployedProcess tenant2InitialProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_2);
        this.processState.updateProcessState(tenant1Process, PersistedProcess.PersistedProcessState.PENDING_DELETION);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)tenant1InitialProcess.getState()).describedAs("Tenant 1 started with ACTIVE state", new Object[0])).isEqualTo((Object)PersistedProcess.PersistedProcessState.ACTIVE);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)tenant2InitialProcess.getState()).describedAs("Tenant 2 started with ACTIVE state", new Object[0])).isEqualTo((Object)PersistedProcess.PersistedProcessState.ACTIVE);
        DeployedProcess tenant1UpdatedProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)tenant1UpdatedProcess.getState()).describedAs("Tenant 1 state is updated", new Object[0])).isEqualTo((Object)PersistedProcess.PersistedProcessState.PENDING_DELETION);
        DeployedProcess tenant2UpdatedProcess = this.processState.getProcessByKeyAndTenant(processKey, TENANT_2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)tenant2UpdatedProcess.getState()).describedAs("Tenant 2 state is unchanged", new Object[0])).isEqualTo((Object)PersistedProcess.PersistedProcessState.ACTIVE);
    }

    @Test
    public void shouldDeleteProcessForTenant() {
        long processKey = this.keyGenerator.nextKey();
        String processId = Strings.newRandomValidBpmnId();
        boolean version = true;
        ProcessRecord tenant1Process = ProcessStateMultiTenantTest.createProcessRecord(TENANT_1, processKey, processId, 1);
        ProcessRecord tenant2Process = ProcessStateMultiTenantTest.createProcessRecord(TENANT_2, processKey, processId, 1);
        this.processState.putProcess(processKey, tenant1Process);
        this.processState.putProcess(processKey, tenant2Process);
        this.processState.deleteProcess(tenant1Process);
        ((ObjectAssert)Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(processKey, TENANT_1)).describedAs("Tenant 1 is removed from the state", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(processKey, TENANT_2)).describedAs("Tenant 2 is not removed from the state", new Object[0])).isNotNull();
    }

    private DeploymentRecord createDeploymentRecord(String tenantId, long processKey, String processId, int version) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("test", task -> task.zeebeJobType("type")).endEvent().done();
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        String resourceName = "process.bpmn";
        DirectBuffer resource = BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance));
        DirectBuffer checksum = BufferUtil.wrapString((String)("checksum" + tenantId));
        ((DeploymentResource)deploymentRecord.setTenantId(tenantId).resources().add()).setResourceName(BufferUtil.wrapString((String)"process.bpmn")).setResource(resource);
        ((ProcessMetadata)deploymentRecord.processesMetadata().add()).setBpmnProcessId(BufferUtil.wrapString((String)processId)).setVersion(version).setKey(processKey).setResourceName("process.bpmn").setChecksum(checksum).setTenantId(tenantId);
        return deploymentRecord;
    }

    public static ProcessRecord createProcessRecord(String tenantId, long processKey, String processId, int version) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("test", task -> task.zeebeJobType("type")).endEvent().done();
        ProcessRecord processRecord = new ProcessRecord();
        String resourceName = "process.bpmn";
        DirectBuffer resource = BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance));
        DirectBuffer checksum = BufferUtil.wrapString((String)("checksum" + tenantId));
        processRecord.setResourceName(BufferUtil.wrapString((String)"process.bpmn")).setResource(resource).setBpmnProcessId(BufferUtil.wrapString((String)processId)).setVersion(version).setKey(processKey).setResourceName("process.bpmn").setChecksum(checksum).setTenantId(tenantId);
        return processRecord;
    }

    private void assertDeployedProcess(DeployedProcess deployedProcess, String expectedTenant, long expectedProcessKey, String expectedProcessId, int expectedVersion) {
        Assertions.assertThat((Object)deployedProcess).extracting(new Function[]{DeployedProcess::getTenantId, DeployedProcess::getKey, DeployedProcess::getBpmnProcessId, DeployedProcess::getVersion}).describedAs("Gets correct process by key and tenant", new Object[0]).containsExactly(new Object[]{expectedTenant, expectedProcessKey, BufferUtil.wrapString((String)expectedProcessId), expectedVersion});
    }
}

