/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.MetricsTestHelper;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ProcessEngineMetricsTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String DMN_RESOURCE = "/dmn/drg-force-user-with-assertions.dmn";
    private static final String PROCESS_ID = "process";
    private static final String TASK_ID = "task";
    @Rule
    public final TestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Before
    public void resetMetrics() {
        ProcessEngineMetrics.EVALUATED_DMN_ELEMENTS.clear();
        ProcessEngineMetrics.EXECUTED_INSTANCES.clear();
        ProcessEngineMetrics.CREATED_PROCESS_INSTANCES.clear();
    }

    @Test
    public void shouldIncreaseSuccessfullyEvaluatedDmnElements() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(TASK_ID, t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("force_user")).zeebeResultVariable("result")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("lightsaberColor", "blue", "height", 175)).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)this.activatedProcessInstanceMetric()).isNotNull()).isEqualTo(1.0);
        ((AbstractDoubleAssert)Assertions.assertThat((Double)this.completedProcessInstanceMetric()).isNotNull()).isEqualTo(1.0);
        ((AbstractDoubleAssert)((AbstractDoubleAssert)Assertions.assertThat((Double)this.succeededEvaluatedDmnElementsMetric()).isNotNull()).describedAs("Expected two decision where executed, i.e. the root decision and one required decision", new Object[0])).isEqualTo(2.0);
    }

    @Test
    public void shouldIncreaseFailedEvaluatedDmnElements() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(TASK_ID, t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("force_user")).zeebeResultVariable("result")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("lightsaberColor", "blue").create();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        ((AbstractDoubleAssert)Assertions.assertThat((Double)this.activatedProcessInstanceMetric()).isNotNull()).isEqualTo(1.0);
        ((AbstractDoubleAssert)Assertions.assertThat((Double)this.terminatedProcessInstanceMetric()).isNotNull()).isEqualTo(1.0);
        ((AbstractDoubleAssert)((AbstractDoubleAssert)Assertions.assertThat((Double)this.failedEvaluatedDmnElementsMetric()).isNotNull()).describedAs("Expected two decision where executed as the required decision succeeded but the root decision failed", new Object[0])).isEqualTo(2.0);
    }

    @Test
    public void shouldIncreaseFailedEvaluatedDmnElementsIfRequiredDecisionFailed() {
        ENGINE.deployment().withXmlClasspathResource(DMN_RESOURCE).withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(TASK_ID, t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId("force_user")).zeebeResultVariable("result")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ((AbstractDoubleAssert)((AbstractDoubleAssert)Assertions.assertThat((Double)this.failedEvaluatedDmnElementsMetric()).isNotNull()).describedAs("Expected only one decision was executed as the required decision failed", new Object[0])).isEqualTo(1.0);
    }

    @Test
    public void shouldIncreaseProcessInstanceCreatedAtDefaultStartEvent() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").endEvent("end").done()).deploy();
        ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Double)this.processInstanceCreationsMetric("creation_at_given_element")).isNull();
        Assertions.assertThat((Double)this.processInstanceCreationsMetric("creation_at_default_start_event")).isEqualTo(1.0);
    }

    @Test
    public void shouldIncreaseProcessInstanceCreatedAtGivenElement() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").endEvent("end").done()).deploy();
        ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("end").create();
        Assertions.assertThat((Double)this.processInstanceCreationsMetric("creation_at_default_start_event")).isNull();
        Assertions.assertThat((Double)this.processInstanceCreationsMetric("creation_at_given_element")).isEqualTo(1.0);
    }

    private Double activatedProcessInstanceMetric() {
        return this.executedProcessInstanceMetric("activated");
    }

    private Double completedProcessInstanceMetric() {
        return this.executedProcessInstanceMetric("completed");
    }

    private Double terminatedProcessInstanceMetric() {
        return this.executedProcessInstanceMetric("terminated");
    }

    private Double executedProcessInstanceMetric(String action) {
        return MetricsTestHelper.readMetricValue("zeebe_executed_instances_total", Map.entry("organizationId", "null"), Map.entry("type", "ROOT_PROCESS_INSTANCE"), Map.entry("action", action), Map.entry("partition", "1"));
    }

    private Double processInstanceCreationsMetric(String creationMode) {
        return MetricsTestHelper.readMetricValue("zeebe_process_instance_creations_total", Map.entry("partition", "1"), Map.entry("creation_mode", creationMode));
    }

    private Double succeededEvaluatedDmnElementsMetric() {
        return this.evaluatedDmnElementsMetric("evaluated_successfully");
    }

    private Double failedEvaluatedDmnElementsMetric() {
        return this.evaluatedDmnElementsMetric("evaluated_failed");
    }

    private Double evaluatedDmnElementsMetric(String action) {
        return MetricsTestHelper.readMetricValue("zeebe_evaluated_dmn_elements_total", Map.entry("organizationId", "null"), Map.entry("action", action), Map.entry("partition", "1"));
    }
}

