/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractEndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class TerminateEndEventTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final BrokerClassRuleHelper brokerClassRuleHelper = new BrokerClassRuleHelper();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCompleteProcessInstance() {
        ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("terminate-end", AbstractEndEventBuilder::terminate).done()).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expect to complete the process instance when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCancelRootElementInstance() {
        ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").userTask("A").endEvent("none-end").moveToNode("fork").serviceTask("B", serviceTask -> serviceTask.zeebeJobType("B")).endEvent("terminate-end", AbstractEndEventBuilder::terminate).done()).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("B").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expect to terminate all element instances when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCancelElementInstanceInEmbeddedSubprocess() {
        Consumer<SubProcessBuilder> subprocessBuilder = subprocess -> subprocess.embeddedSubProcess().startEvent().parallelGateway("subprocess_fork").userTask("B").endEvent("end_after_B").moveToNode("subprocess_fork").serviceTask("C", serviceTask -> serviceTask.zeebeJobType("C")).endEvent("terminate-end", AbstractEndEventBuilder::terminate);
        BpmnModelInstance process = ((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("process_fork").serviceTask("A", serviceTask -> serviceTask.zeebeJobType("A")).endEvent("end_after_A").moveToNode("process_fork").subProcess("subprocess", subprocessBuilder).sequenceFlowId("to_end_after_subprocess")).endEvent("end_after_subprocess").done();
        ENGINE_RULE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("C").complete();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limit("end_after_subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate all element instances in the subprocess when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "C", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "terminate-end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATED})})).describedAs("Expect to complete the subprocess and take the outgoing sequence flow", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, "to_end_after_subprocess", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "end_after_subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED})})).describedAs("Expect that the element instances outside of the subprocess are not terminated", new Object[0]).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED})});
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("A").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to complete the process instance after all element instances are completed", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "A", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "end_after_A", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCancelElementInstanceInEventSubprocess() {
        String messageName = this.brokerClassRuleHelper.getMessageName();
        String correlationKey = this.brokerClassRuleHelper.getCorrelationValue();
        Consumer<EventSubProcessBuilder> eventSubprocessBuilder = eventSubprocess -> ((StartEventBuilder)((StartEventBuilder)eventSubprocess.startEvent().interrupting(false)).message(message -> message.name(messageName).zeebeCorrelationKeyExpression("key"))).parallelGateway("fork").userTask("B").endEvent("end_after_B").moveToNode("fork").serviceTask("C", serviceTask -> serviceTask.zeebeJobType("C")).endEvent("terminate-end", AbstractEndEventBuilder::terminate);
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event_subprocess", eventSubprocessBuilder).startEvent().serviceTask("A", serviceTask -> serviceTask.zeebeJobType("A")).endEvent("end_after_A").done();
        ENGINE_RULE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", correlationKey).create();
        ENGINE_RULE.message().withName(messageName).withCorrelationKey(correlationKey).withTimeToLive(Duration.ofHours(1L)).publish();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("C").complete();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limit("event_subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate all element instances in the event subprocess when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "C", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "terminate-end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATED})})).describedAs("Expect to complete the event subprocess", new Object[0]).contains((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, "event_subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED})})).describedAs("Expect that the element instances outside of the event subprocess are not terminated", new Object[0]).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED})});
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("A").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to complete the process instance after all element instances are completed", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "A", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "end_after_A", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCancelElementInstanceInMultiInstance() {
        Consumer<SubProcessBuilder> subprocessBuilder = subprocess -> ((ExclusiveGatewayBuilder)subprocess.embeddedSubProcess().startEvent().exclusiveGateway("split").defaultFlow()).parallelGateway("fork_1").userTask("A").endEvent("end_after_A").moveToNode("fork_1").serviceTask("B", serviceTask -> serviceTask.zeebeJobType("B")).endEvent("terminate_end_after_B", AbstractEndEventBuilder::terminate).moveToNode("split").conditionExpression("x = 2").parallelGateway("fork_2").userTask("C").endEvent("end_after_C").moveToNode("fork_2").serviceTask("D", serviceTask -> serviceTask.zeebeJobType("D")).endEvent("terminate_end_after_D", AbstractEndEventBuilder::terminate);
        BpmnModelInstance process = ((SubProcessBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subprocessBuilder).multiInstance(multiInstance -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)multiInstance.parallel()).zeebeInputCollectionExpression("[1,2]")).zeebeInputElement("x"))).sequenceFlowId("to_end_after_subprocess")).endEvent("end_after_subprocess").done();
        ENGINE_RULE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(4L)).describedAs("Assume that four jobs are created, two for each subprocess instance", new Object[0])).hasSize(4);
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limit("subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate all element instances in the subprocess when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "B", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "terminate_end_after_B", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED})})).describedAs("Expect that the other instance of the subprocess is not terminated", new Object[0]).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "C", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "D", ProcessInstanceIntent.ELEMENT_TERMINATED})});
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("D").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to complete the other subprocess instance", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "D", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "C", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED})})).describedAs("Expect to complete the multi-instance after all subprocess instances are completed", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "end_after_subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCancelChildProcessInstance() {
        String childProcessId = this.brokerClassRuleHelper.getBpmnProcessId();
        BpmnModelInstance childProcess = Bpmn.createExecutableProcess((String)childProcessId).startEvent().parallelGateway("fork").userTask("A").endEvent("none-end").moveToNode("fork").serviceTask("B", serviceTask -> serviceTask.zeebeJobType("B")).endEvent("terminate-end", AbstractEndEventBuilder::terminate).done();
        BpmnModelInstance parentProcess = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("C", callActivity -> callActivity.zeebeProcessId(childProcessId)).sequenceFlowId("to_end_after_C")).endEvent("end_after_C").done();
        ENGINE_RULE.deployment().withXmlResource("parent.bpmn", parentProcess).withXmlResource("child.bpmn", childProcess).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long childProcessInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).getFirst()).getKey();
        ENGINE_RULE.job().ofInstance(childProcessInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKeyOrParentProcessInstanceKey(processInstanceKey).limit(PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate all element instances in the child process instance when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, "B", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "terminate-end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED})})).describedAs("Expect to complete the child process instance and the call activity", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, childProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, "C", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, "to_end_after_C", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "end_after_C", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCompleteProcessWhenWaitingAtParallelGateway() {
        ENGINE_RULE.deployment().withXmlResource(((EndEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").parallelGateway("join").moveToNode("fork").serviceTask("A", s -> s.zeebeJobType("type")).boundaryEvent().error("code")).endEvent().terminate()).moveToNode("A").connectTo("join").endEvent().done()).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("type").withErrorCode("code").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expect to terminate all element instances when reaching the terminate end event", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

