/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.MultiInstanceOutputCollectionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLoopCharacteristics;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;

@ExtendWith(value={MockitoExtension.class})
public class MultiInstanceOutputCollectionBehaviorTest {
    @Test
    void shouldReturnFailureWhenWritingToOutputCollectionOutOfBounds() {
        DirectBuffer collectionWithSize1 = this.createCollection(1);
        DirectBuffer elementToAdd = this.createMsgPackString("element to add");
        int indexThatIsOutOfBounds = 2;
        StaticExpression outputElementExpression = new StaticExpression("dummy expression");
        DirectBuffer outputCollectionName = BufferUtil.wrapString((String)"OUTPUT_COLLECTION");
        ExecutableLoopCharacteristics loopCharacteristics = this.createLoopCharacteristics(outputCollectionName, (Expression)outputElementExpression);
        long flowScopeContextKey = 12345L;
        BpmnStateBehavior mockStateBehavior = (BpmnStateBehavior)Mockito.mock(BpmnStateBehavior.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockStateBehavior.getLocalVariable((BpmnElementContext)ArgumentMatchers.any(), (DirectBuffer)ArgumentMatchers.eq((Object)outputCollectionName))).thenReturn((Object)collectionWithSize1);
        ExpressionProcessor mockExpressionProcessor = (ExpressionProcessor)Mockito.mock(ExpressionProcessor.class);
        Mockito.when((Object)mockExpressionProcessor.evaluateAnyExpression((Expression)ArgumentMatchers.eq((Object)outputElementExpression), ArgumentMatchers.anyLong())).thenReturn((Object)Either.right((Object)elementToAdd));
        ExecutableMultiInstanceBody mockElement = (ExecutableMultiInstanceBody)Mockito.mock(ExecutableMultiInstanceBody.class);
        Mockito.when((Object)mockElement.getLoopCharacteristics()).thenReturn((Object)loopCharacteristics);
        BpmnElementContext mockChildContext = (BpmnElementContext)Mockito.mock(BpmnElementContext.class);
        Mockito.when((Object)mockStateBehavior.getElementInstance(mockChildContext).getMultiInstanceLoopCounter()).thenReturn((Object)2);
        BpmnElementContext mockFlowScopeContext = (BpmnElementContext)Mockito.mock(BpmnElementContext.class);
        Mockito.when((Object)mockFlowScopeContext.getElementInstanceKey()).thenReturn((Object)12345L);
        MultiInstanceOutputCollectionBehavior sut = new MultiInstanceOutputCollectionBehavior(mockStateBehavior, mockExpressionProcessor);
        Either result = sut.updateOutputCollection(mockElement, mockChildContext, mockFlowScopeContext);
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Failure failure = (Failure)result.getLeft();
        Assertions.assertThat((Comparable)failure.getErrorType()).isEqualTo((Object)ErrorType.EXTRACT_VALUE_ERROR);
        Assertions.assertThat((String)failure.getMessage()).isEqualTo("Unable to update an item in output collection 'OUTPUT_COLLECTION' at position 2 because the size of the collection is: 1. This may happen when multiple BPMN elements write to the same variable.");
        Assertions.assertThat((long)failure.getVariableScopeKey()).isEqualTo(12345L);
    }

    @Test
    void shouldReturnFailureWhenWritingToOutputCollectionWhichIsNotArray() {
        DirectBuffer unexpectedValueType = this.createMsgPackString("lorem ipsum");
        DirectBuffer elementToAdd = this.createMsgPackString("element to add");
        boolean index = true;
        StaticExpression outputElementExpression = new StaticExpression("dummy expression");
        DirectBuffer outputCollectionName = BufferUtil.wrapString((String)"OUTPUT_COLLECTION");
        ExecutableLoopCharacteristics loopCharacteristics = this.createLoopCharacteristics(outputCollectionName, (Expression)outputElementExpression);
        long flowScopeContextKey = 12345L;
        BpmnStateBehavior mockStateBehavior = (BpmnStateBehavior)Mockito.mock(BpmnStateBehavior.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockStateBehavior.getLocalVariable((BpmnElementContext)ArgumentMatchers.any(), (DirectBuffer)ArgumentMatchers.eq((Object)outputCollectionName))).thenReturn((Object)unexpectedValueType);
        ExpressionProcessor mockExpressionProcessor = (ExpressionProcessor)Mockito.mock(ExpressionProcessor.class);
        Mockito.when((Object)mockExpressionProcessor.evaluateAnyExpression((Expression)ArgumentMatchers.eq((Object)outputElementExpression), ArgumentMatchers.anyLong())).thenReturn((Object)Either.right((Object)elementToAdd));
        ExecutableMultiInstanceBody mockElement = (ExecutableMultiInstanceBody)Mockito.mock(ExecutableMultiInstanceBody.class);
        Mockito.when((Object)mockElement.getLoopCharacteristics()).thenReturn((Object)loopCharacteristics);
        BpmnElementContext mockChildContext = (BpmnElementContext)Mockito.mock(BpmnElementContext.class);
        Mockito.when((Object)mockStateBehavior.getElementInstance(mockChildContext).getMultiInstanceLoopCounter()).thenReturn((Object)1);
        BpmnElementContext mockFlowScopeContext = (BpmnElementContext)Mockito.mock(BpmnElementContext.class);
        Mockito.when((Object)mockFlowScopeContext.getElementInstanceKey()).thenReturn((Object)12345L);
        MultiInstanceOutputCollectionBehavior sut = new MultiInstanceOutputCollectionBehavior(mockStateBehavior, mockExpressionProcessor);
        Either result = sut.updateOutputCollection(mockElement, mockChildContext, mockFlowScopeContext);
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Failure failure = (Failure)result.getLeft();
        Assertions.assertThat((Comparable)failure.getErrorType()).isEqualTo((Object)ErrorType.EXTRACT_VALUE_ERROR);
        Assertions.assertThat((String)failure.getMessage()).isEqualTo("Unable to update an item in output collection 'OUTPUT_COLLECTION' because the type of the output collection is: STRING. This may happen when multiple BPMN elements write to the same variable.");
        Assertions.assertThat((long)failure.getVariableScopeKey()).isEqualTo(12345L);
    }

    private ExecutableLoopCharacteristics createLoopCharacteristics(DirectBuffer outputCollection, Expression outputElement) {
        return new ExecutableLoopCharacteristics(false, Optional.empty(), null, Optional.empty(), Optional.of(outputCollection), Optional.of(outputElement));
    }

    private DirectBuffer createCollection(int size) {
        MsgPackWriter writer = new MsgPackWriter();
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        writer.wrap((MutableDirectBuffer)buffer, 0);
        writer.writeArrayHeader(size);
        for (int i = 0; i < size; ++i) {
            writer.writeNil();
        }
        int length = writer.getOffset();
        return BufferUtil.cloneBuffer((DirectBuffer)buffer, (int)0, (int)length);
    }

    private DirectBuffer createMsgPackString(String input) {
        MsgPackWriter writer = new MsgPackWriter();
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        writer.wrap((MutableDirectBuffer)buffer, 0);
        writer.writeString(BufferUtil.wrapString((String)input));
        int length = writer.getOffset();
        return BufferUtil.cloneBuffer((DirectBuffer)buffer, (int)0, (int)length);
    }
}

