/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.boundary;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractActivityBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class BoundaryEventElementTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String CALL_ACTIVITY_PROCESS = "process2";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter
    public ElementWithBoundaryEventBuilder elementBuilder;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return BoundaryEventElementTest.buildersAsParameters();
    }

    private BpmnModelInstance process(ElementWithBoundaryEventBuilder elementBuilder) {
        StartEventBuilder startEventBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent();
        AbstractActivityBuilder<?, ?> processWithElementBuilder = elementBuilder.build((AbstractFlowNodeBuilder<?, ?>)startEventBuilder);
        return ((BoundaryEventBuilder)processWithElementBuilder.boundaryEvent().timerWithDuration("PT1H")).endEvent().done();
    }

    @Test
    public void shouldNotActivateBoundaryEventIfScopeIsTerminating() {
        ENGINE.deployment().withXmlResource(this.process(this.elementBuilder)).deploy();
        if (this.elementBuilder.deployCalledProcess()) {
            ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)CALL_ACTIVITY_PROCESS).startEvent().userTask().endEvent().done()).deploy();
        }
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(this.elementBuilder.elementType).await();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)new ProcessInstanceRecord()).key(processInstanceKey), RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)timerCreated.getValue()).key(timerCreated.getKey()));
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{this.elementBuilder.elementType, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{this.elementBuilder.elementType, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING})});
    }

    /*
     * Exception decompiling
     */
    private static Collection<Object[]> buildersAsParameters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Stream<ElementWithBoundaryEventBuilder> builders() {
        return Stream.of(new ElementWithBoundaryEventBuilder(BpmnElementType.SERVICE_TASK, process -> process.serviceTask("task", t -> t.zeebeJobType("task")), false), new ElementWithBoundaryEventBuilder(BpmnElementType.RECEIVE_TASK, process -> process.receiveTask("task", r -> r.message(m -> m.name("wait").zeebeCorrelationKeyExpression("123"))), false), new ElementWithBoundaryEventBuilder(BpmnElementType.BUSINESS_RULE_TASK, process -> process.businessRuleTask("task", b -> b.zeebeJobType("task")), false), new ElementWithBoundaryEventBuilder(BpmnElementType.USER_TASK, process -> process.userTask("task"), false), new ElementWithBoundaryEventBuilder(BpmnElementType.SCRIPT_TASK, process -> process.scriptTask("task", s -> s.zeebeJobType("task")), false), new ElementWithBoundaryEventBuilder(BpmnElementType.SEND_TASK, process -> process.sendTask("task", s -> s.zeebeJobType("task")), false), new ElementWithBoundaryEventBuilder(BpmnElementType.SUB_PROCESS, process -> process.subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent()), false), new ElementWithBoundaryEventBuilder(BpmnElementType.MULTI_INSTANCE_BODY, process -> process.serviceTask("task", t -> t.zeebeJobType("task")).multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.parallel()).zeebeInputCollectionExpression("[1,2,3]")), false), new ElementWithBoundaryEventBuilder(BpmnElementType.CALL_ACTIVITY, process -> process.callActivity("call", c -> c.zeebeProcessId(CALL_ACTIVITY_PROCESS)), true));
    }

    private record ElementWithBoundaryEventBuilder(BpmnElementType elementType, Function<AbstractFlowNodeBuilder<?, ?>, AbstractActivityBuilder<?, ?>> builder, boolean deployCalledProcess) {
        public AbstractActivityBuilder<?, ?> build(AbstractFlowNodeBuilder<?, ?> process) {
            return this.builder.apply(process);
        }

        @Override
        public String toString() {
            return this.elementType.name();
        }
    }
}

