/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.error;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractStartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ErrorEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "wf";
    private static final String JOB_TYPE = "test";
    private static final String ERROR_CODE = "ERROR";
    private static final String ERROR_CODE_NUMBER = "404";
    private static final BpmnModelInstance SINGLE_BOUNDARY_EVENT = ErrorEventTest.process(serviceTask -> serviceTask.boundaryEvent("error", b -> b.error(ERROR_CODE)).endEvent());
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance process(Consumer<ServiceTaskBuilder> customizer) {
        ServiceTaskBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType(JOB_TYPE));
        customizer.accept(builder);
        return builder.endEvent().done();
    }

    @Test
    public void shouldTriggerEvent() {
        ENGINE.deployment().withXmlResource(SINGLE_BOUNDARY_EVENT).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCatchErrorEventsByErrorCode() {
        ENGINE.deployment().withXmlResource(ErrorEventTest.process(serviceTask -> {
            serviceTask.boundaryEvent("error-1", b -> ((BoundaryEventBuilder)b.error("error-1")).endEvent());
            serviceTask.boundaryEvent("error-2", b -> ((BoundaryEventBuilder)b.error("error-2")).endEvent());
        })).deploy();
        long processInstanceKey1 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long processInstanceKey2 = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey1).withType(JOB_TYPE).withErrorCode("error-1").throwError();
        ENGINE.job().ofInstance(processInstanceKey2).withType(JOB_TYPE).withErrorCode("error-2").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey1).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BOUNDARY_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"error-1"});
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey2).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BOUNDARY_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"error-2"});
    }

    @Test
    public void shouldCatchErrorEventsByNumericErrorCode() {
        ENGINE.deployment().withXmlResource(ErrorEventTest.process(serviceTask -> serviceTask.boundaryEvent("error", b -> ((BoundaryEventBuilder)b.error(ERROR_CODE_NUMBER)).endEvent()))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE_NUMBER).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCatchErrorEventsOnBoundaryEventWithoutErrorRef() {
        ENGINE.deployment().withXmlResource(ErrorEventTest.process(serviceTask -> serviceTask.boundaryEvent("error", b -> b.errorEventDefinition().errorEventDefinitionDone().endEvent()))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("error").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BOUNDARY_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"error"});
    }

    @Test
    public void shouldCatchErrorEventsOnBoundaryEventWithoutErrorCode() {
        ENGINE.deployment().withXmlResource(ErrorEventTest.process(serviceTask -> serviceTask.boundaryEvent("error", b -> ((BoundaryEventBuilder)b.error()).endEvent()))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("error").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BOUNDARY_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"error"});
    }

    @Test
    public void shouldCatchErrorEventsOnBoundaryEventWithSpecificErrorCode() {
        ENGINE.deployment().withXmlResource(ErrorEventTest.process(serviceTask -> {
            serviceTask.boundaryEvent("catch-all", b -> ((BoundaryEventBuilder)b.error()).endEvent());
            serviceTask.boundaryEvent("code-specific", b -> ((BoundaryEventBuilder)b.error(ERROR_CODE)).endEvent());
        })).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BOUNDARY_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"code-specific"});
    }

    @Test
    public void shouldCatchErrorEventsOnErrorStartEventWithoutErrorRef() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("sub", e -> e.startEvent("error", AbstractStartEventBuilder::errorEventDefinition).endEvent()).startEvent("start").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("errorCode").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence((Object[])new String[]{"start", "error"});
    }

    @Test
    public void shouldCatchErrorEventsOnErrorStartEventWithEmptyErrorCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("sub", e -> e.startEvent("error", s -> s.error(null)).endEvent()).startEvent("start").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("errorCode").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence((Object[])new String[]{"start", "error"});
    }

    @Test
    public void shouldCatchErrorEventsOnErrorStartEventWithoutErrorCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("sub", e -> e.startEvent("error", AbstractStartEventBuilder::error).endEvent()).startEvent("start").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("errorCode").throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence((Object[])new String[]{"start", "error"});
    }

    @Test
    public void shouldCatchErrorEventsOnErrorStartEventWithSpecificErrorCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("sub-1", e -> e.startEvent("catch-all", AbstractStartEventBuilder::error).endEvent()).eventSubProcess("sub-2", e -> e.startEvent("code-specific", s -> s.error(ERROR_CODE)).endEvent()).startEvent("start").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence((Object[])new String[]{"start", "code-specific"});
    }

    @Test
    public void shouldNotCancelJob() {
        ENGINE.deployment().withXmlResource(SINGLE_BOUNDARY_EVENT).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).jobRecords()).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{JobIntent.CREATED, JobIntent.THROW_ERROR, JobIntent.ERROR_THROWN});
    }

    @Test
    public void shouldCatchErrorFromChildInstance() {
        BpmnModelInstance processChild = Bpmn.createExecutableProcess((String)"wf-child").startEvent().serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().done();
        BpmnModelInstance processParent = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("call", c -> c.zeebeProcessId("wf-child")).boundaryEvent("error", b -> ((BoundaryEventBuilder)b.error(ERROR_CODE)).endEvent()).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-child.bpmn", processChild).withXmlResource("wf-parent.bpmn", processParent).deploy();
        long parentProcessInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long childProcessInstanceKey = ((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(parentProcessInstanceKey).getFirst()).getValue()).getProcessInstanceKey();
        ENGINE.job().ofInstance(childProcessInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(childProcessInstanceKey).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(parentProcessInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCatchErrorInsideMultiInstanceSubprocess() {
        Consumer<EventSubProcessBuilder> eventSubprocess = s -> ((StartEventBuilder)s.startEvent("error-start-event").error(ERROR_CODE)).endEvent();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.multiInstance(m -> m.zeebeInputCollectionExpression("items"))).embeddedSubProcess().eventSubProcess("error-subprocess", eventSubprocess).startEvent().serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent()).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("items", List.of(Integer.valueOf(1))).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{"error-subprocess", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"error-start-event", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{"error-start-event", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"error-subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCatchErrorOutsideMultiInstanceSubprocess() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.multiInstance(m -> m.zeebeInputCollectionExpression("[1]"))).embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent()).boundaryEvent("error-boundary-event", b -> b.error(ERROR_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldThrowErrorOnEndEvent() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subProcess", subProcess -> subProcess.embeddedSubProcess().startEvent().endEvent("throw-error", e -> e.error(ERROR_CODE))).boundaryEvent("catch-error", b -> b.error(ERROR_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().onlyEvents()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldThrowErrorOnEndEventWithExpression() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subProcess", subProcess -> subProcess.embeddedSubProcess().startEvent().endEvent("throw-error", e -> e.errorExpression("error"))).boundaryEvent("catch-error", b -> b.error(ERROR_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("error", ERROR_CODE)).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().onlyEvents()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

