/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.escalation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractStartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.EscalationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class EscalationEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String TASK_ELEMENT_ID = "task";
    private static final String PROCESS_ID = "wf";
    private static final String ESCALATION_CODE = "ESCALATION";
    private static final String ESCALATION_CODE_NUMBER = "404";
    private static final String THROW_ELEMENT_ID = "throw";
    private static final String CATCH_ELEMENT_ID = "catch";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldThrowEscalationFromEscalationIntermediateThrowEvent() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsNotEscalated(THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldThrowEscalationFromEndEvent() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("end", e -> e.escalation(ESCALATION_CODE)).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsNotEscalated("end", ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnBoundaryEventWithoutEscalationCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE))).boundaryEvent(CATCH_ELEMENT_ID, AbstractBoundaryEventBuilder::escalation).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnBoundaryEventWithNumericEscalationCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE_NUMBER))).boundaryEvent(CATCH_ELEMENT_ID, AbstractBoundaryEventBuilder::escalation).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE_NUMBER);
    }

    @Test
    public void shouldCatchEscalationInsideMultiInstanceSubprocess() {
        Consumer<EventSubProcessBuilder> eventSubprocess = s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent("escalation-start-event").escalation(ESCALATION_CODE)).interrupting(false)).endEvent();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.multiInstance(m -> m.zeebeInputCollectionExpression("items"))).embeddedSubProcess().eventSubProcess("escalation-subprocess", eventSubprocess).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("items", List.of(Integer.valueOf(1), Integer.valueOf(2))).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType()).containsSubsequence((Object[])new BpmnElementType[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnElementType.START_EVENT, BpmnElementType.MANUAL_TASK, BpmnElementType.START_EVENT, BpmnElementType.MANUAL_TASK, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.SUB_PROCESS, BpmnElementType.SUB_PROCESS, BpmnElementType.MULTI_INSTANCE_BODY, BpmnElementType.PROCESS});
        this.assertIsEscalated(processInstanceKey, "escalation-start-event", THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOutsideMultiInstanceSubprocess() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.multiInstance(m -> m.zeebeInputCollectionExpression("[1]"))).embeddedSubProcess().startEvent().endEvent(THROW_ELEMENT_ID, e -> e.escalation(ESCALATION_CODE))).boundaryEvent("escalation-boundary-event", b -> b.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, "escalation-boundary-event", THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldThrowEscalationEventHierarchical() {
        BpmnModelInstance processChild = Bpmn.createExecutableProcess((String)"wf-child").startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).endEvent()).endEvent().done();
        BpmnModelInstance processParent = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("call", c -> c.zeebeProcessId("wf-child")).boundaryEvent(CATCH_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-child.bpmn", processChild).withXmlResource("wf-parent.bpmn", processParent).deploy();
        long parentProcessInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(parentProcessInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        long childProcessInstanceKey = ((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(parentProcessInstanceKey).getFirst()).getValue()).getProcessInstanceKey();
        this.assertIsEscalated(childProcessInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnNonInterruptingBoundaryEventWhenThrowEscalationEventHierarchical() {
        BpmnModelInstance processChild = Bpmn.createExecutableProcess((String)"wf-child").startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent()).endEvent().done();
        BpmnModelInstance processParent = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("call", c -> c.zeebeProcessId("wf-child")).boundaryEvent(CATCH_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).cancelActivity(Boolean.valueOf(false))).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-child.bpmn", processChild).withXmlResource("wf-parent.bpmn", processParent).deploy();
        long parentProcessInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(parentProcessInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        long childProcessInstanceKey = ((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(parentProcessInstanceKey).getFirst()).getValue()).getProcessInstanceKey();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(childProcessInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType()).containsSubsequence((Object[])new BpmnElementType[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, BpmnElementType.MANUAL_TASK, BpmnElementType.END_EVENT});
        this.assertIsEscalated(childProcessInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnEscalationStartEventWhenThrowEscalationEventHierarchical() {
        BpmnModelInstance processChild = Bpmn.createExecutableProcess((String)"wf-child").startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).endEvent().done();
        BpmnModelInstance processParent = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("escalation-event-subprocess", e -> ((StartEventBuilder)((StartEventBuilder)e.startEvent(CATCH_ELEMENT_ID).interrupting(false)).escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent()).startEvent().callActivity("call", c -> c.zeebeProcessId("wf-child")).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-child.bpmn", processChild).withXmlResource("wf-parent.bpmn", processParent).deploy();
        long parentProcessInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(parentProcessInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        long childProcessInstanceKey = ((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(parentProcessInstanceKey).getFirst()).getValue()).getProcessInstanceKey();
        this.assertIsEscalated(childProcessInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationEventsByEscalationCode() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().parallelGateway("fork").intermediateThrowEvent("throw-1", i -> i.escalation("escalation-1")).moveToLastGateway().intermediateThrowEvent("throw-2", i -> i.escalation("escalation-2"))).boundaryEvent("catch-1", b -> b.escalation("escalation-1")).cancelActivity(Boolean.valueOf(false))).endEvent().moveToActivity("subprocess").boundaryEvent("catch-2", b -> b.escalation("escalation-2")).cancelActivity(Boolean.valueOf(false))).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.BOUNDARY_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).contains((Object[])new String[]{"catch-1", "catch-2"});
        this.assertIsEscalated(processInstanceKey, "catch-1", "throw-1", "escalation-1");
        this.assertIsEscalated(processInstanceKey, "catch-2", "throw-2", "escalation-2");
    }

    @Test
    public void shouldCatchEscalationOnNonInterruptingBoundaryEventWithEscalationCode() {
        BpmnModelInstance process = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID)).boundaryEvent(CATCH_ELEMENT_ID, b -> b.escalation(ESCALATION_CODE)).cancelActivity(Boolean.valueOf(false))).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnNonInterruptingBoundaryEventWithoutEscalationCode() {
        BpmnModelInstance process = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE))).boundaryEvent(CATCH_ELEMENT_ID, AbstractBoundaryEventBuilder::escalation).cancelActivity(Boolean.valueOf(false))).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnNonInterruptingEscalationStartEventWithEscalationCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("escalation-event-subprocess", e -> ((StartEventBuilder)((StartEventBuilder)e.startEvent(CATCH_ELEMENT_ID).interrupting(false)).escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent()).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnNonInterruptingEscalationStartEventWithoutEscalationCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("escalation-event-subprocess", e -> ((StartEventBuilder)((StartEventBuilder)e.startEvent(CATCH_ELEMENT_ID).interrupting(false)).escalation()).manualTask(TASK_ELEMENT_ID).endEvent()).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldThrowEscalationFromIntermediateThrowEventWithExpression() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, b -> b.escalationExpression("escalationCode")).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("escalationCode", ESCALATION_CODE)).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsNotEscalated(THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldThrowEscalationFromEndEventWithExpression() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("end", e -> e.escalationExpression("escalationCode")).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("escalationCode", ESCALATION_CODE)).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsNotEscalated("end", ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationByEscalationCodeWithExpression() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("escalation-event-subprocess", e -> ((StartEventBuilder)((StartEventBuilder)e.startEvent(CATCH_ELEMENT_ID).interrupting(false)).escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent()).startEvent().endEvent(THROW_ELEMENT_ID, e -> e.escalationExpression("escalationCode")).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("escalationCode", ESCALATION_CODE)).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, CATCH_ELEMENT_ID, THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnBoundaryEventWithSpecificEscalationCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().endEvent(THROW_ELEMENT_ID, i -> i.escalation(ESCALATION_CODE))).boundaryEvent("catch-all", AbstractBoundaryEventBuilder::escalation).endEvent().moveToActivity("subprocess").boundaryEvent("code-specific", b -> b.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, "code-specific", THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    @Test
    public void shouldCatchEscalationOnEscalstionStartEventWithSpecificEscalationCode() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("sub-1", e -> e.startEvent("catch-all", AbstractStartEventBuilder::escalation).endEvent()).eventSubProcess("sub-2", e -> e.startEvent("code-specific", s -> s.escalation(ESCALATION_CODE)).manualTask(TASK_ELEMENT_ID)).startEvent().endEvent(THROW_ELEMENT_ID, e -> e.escalation(ESCALATION_CODE)).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        this.assertIsEscalated(processInstanceKey, "code-specific", THROW_ELEMENT_ID, ESCALATION_CODE);
    }

    private void assertIsNotEscalated(String throwElementId, String escalationCode) {
        Assertions.assertThat((boolean)RecordingExporter.escalationRecords((EscalationIntent)EscalationIntent.NOT_ESCALATED).withCatchElementId("").withThrowElementId(throwElementId).withEscalationCode(escalationCode).exists()).isTrue();
    }

    private void assertIsEscalated(long processInstanceKey, String catchElementId, String throwElementId, String escalationCode) {
        Assertions.assertThat((boolean)RecordingExporter.escalationRecords((EscalationIntent)EscalationIntent.ESCALATED).withProcessInstanceKey(processInstanceKey).withCatchElementId(catchElementId).withThrowElementId(throwElementId).withEscalationCode(escalationCode).exists()).isTrue();
    }
}

