/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.multiinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.JsonUtil;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class MultiInstanceInputCollectionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String ELEMENT_ID = "task";
    private static final String INPUT_COLLECTION = "items";
    private static final String INPUT_ELEMENT = "item";
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).multiInstance(b -> ((MultiInstanceLoopCharacteristicsBuilder)b.zeebeInputCollectionExpression(INPUT_COLLECTION)).zeebeInputElement(INPUT_ELEMENT))).endEvent().done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public Collection<?> inputCollection;

    @Parameterized.Parameters(name="with input collection: {0}")
    public static Object[][] parameters() {
        return new Object[][]{{Arrays.asList("a")}, {Arrays.asList(true, false)}, {Arrays.asList(10, 20, 30)}, {Arrays.asList(Collections.singletonMap("x", 1), Collections.singletonMap("x", 2), Collections.singletonMap("x", 3))}, {Arrays.asList(ELEMENT_ID, null, true, 40)}};
    }

    @Test
    public void test() {
        ENGINE.deployment().withXmlResource(PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(INPUT_COLLECTION, this.inputCollection).create();
        int collectionSize = this.inputCollection.size();
        List elementInstanceKeys = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId(ELEMENT_ID).withProcessInstanceKey(processInstanceKey).limit((long)(collectionSize + 1))).map(Record::getKey).collect(Collectors.toList());
        Assertions.assertThat(elementInstanceKeys).hasSize(collectionSize + 1);
        List variables = ((VariableRecordStream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withName(INPUT_ELEMENT).withProcessInstanceKey(processInstanceKey).limit((long)collectionSize)).asList();
        List expectedVariableValues = this.inputCollection.stream().map(JsonUtil::toJson).collect(Collectors.toList());
        Assertions.assertThat((List)variables).extracting(r -> ((VariableRecordValue)r.getValue()).getValue()).containsExactlyElementsOf(expectedVariableValues);
        Assertions.assertThat((List)variables).extracting(r -> ((VariableRecordValue)r.getValue()).getScopeKey()).containsExactlyElementsOf(elementInstanceKeys.subList(1, elementInstanceKeys.size()));
    }
}

