/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.subprocess;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NonInterruptingEventSubprocessTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "proc";
    private static final String CORRELATION_KEY = "123";
    private static String messageName;
    private static String signalName;
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    @Parameterized.Parameter
    public String testName;
    @Parameterized.Parameter(value=1)
    public Function<StartEventBuilder, StartEventBuilder> builder;
    @Parameterized.Parameter(value=2)
    public Consumer<Long> triggerEventSubprocess;
    @Parameterized.Parameter(value=3)
    public Boolean cyclic;
    private ProcessMetadataValue currentProcess;
    private String correlationKey;

    @Parameterized.Parameters(name="{0} event subprocess")
    public static Object[][] parameters() {
        return new Object[][]{{"timer with duration", NonInterruptingEventSubprocessTest.eventSubprocess(s -> (StartEventBuilder)s.timerWithDuration("PT60S")), NonInterruptingEventSubprocessTest.eventTrigger(key -> {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(key.longValue()).exists()).describedAs("Expected timer to exist", new Object[0])).isTrue();
            ENGINE.increaseTime(Duration.ofSeconds(60L));
        }), false}, {"timer with date", NonInterruptingEventSubprocessTest.eventSubprocess(s -> (StartEventBuilder)s.timerWithDateExpression("now() + duration(\"PT1M\")")), NonInterruptingEventSubprocessTest.eventTrigger(key -> {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(key.longValue()).exists()).describedAs("Expected timer to exist", new Object[0])).isTrue();
            ENGINE.increaseTime(Duration.ofSeconds(60L));
        }), false}, {"timer with cycle", NonInterruptingEventSubprocessTest.eventSubprocess(s -> (StartEventBuilder)s.timerWithCycle("R/PT60S")), NonInterruptingEventSubprocessTest.eventTrigger(key -> {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(key.longValue()).exists()).describedAs("Expected timer to exist", new Object[0])).isTrue();
            ENGINE.increaseTime(Duration.ofSeconds(60L));
        }), true}, {"message", NonInterruptingEventSubprocessTest.eventSubprocess(s -> (StartEventBuilder)s.message(b -> b.name(messageName).zeebeCorrelationKeyExpression("key"))), NonInterruptingEventSubprocessTest.eventTrigger(key -> {
            RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(key.longValue()).withMessageName(messageName).await();
            ENGINE.message().withName(messageName).withCorrelationKey("message-123").publish();
        }), true}, {"signal", NonInterruptingEventSubprocessTest.eventSubprocess(s -> (StartEventBuilder)s.signal(b -> b.name(signalName))), NonInterruptingEventSubprocessTest.eventTrigger(key -> {
            RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(signalName).await();
            ENGINE.signal().withSignalName(signalName).broadcast();
        }), true}};
    }

    private static Function<StartEventBuilder, StartEventBuilder> eventSubprocess(Function<StartEventBuilder, StartEventBuilder> consumer) {
        return consumer;
    }

    private static Consumer<Long> eventTrigger(Consumer<Long> eventTrigger) {
        return eventTrigger;
    }

    @Before
    public void init() {
        messageName = this.helper.getMessageName();
        signalName = this.helper.getSignalName();
        this.correlationKey = String.format("%s-%s", this.testName, CORRELATION_KEY);
    }

    @Test
    public void shouldTriggerEventSubprocess() {
        BpmnModelInstance model = NonInterruptingEventSubprocessTest.eventSubprocModel(this.builder);
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        Record startEventActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_start").withElementType(BpmnElementType.START_EVENT).withProcessInstanceKey(processInstanceKey).getFirst();
        Record subProcessActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_proc").withElementType(BpmnElementType.EVENT_SUB_PROCESS).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)startEventActivated.getValue())).hasProcessDefinitionKey(this.currentProcess.getProcessDefinitionKey()).hasProcessInstanceKey(processInstanceKey).hasBpmnElementType(BpmnElementType.START_EVENT).hasElementId("event_sub_start").hasVersion(this.currentProcess.getVersion()).hasFlowScopeKey(subProcessActivated.getKey());
        NonInterruptingEventSubprocessTest.assertEventSubprocessLifecycle(processInstanceKey);
    }

    @Test
    public void shouldTriggerEventSubprocessTwice() {
        Assume.assumeTrue((boolean)this.cyclic);
        BpmnModelInstance model = NonInterruptingEventSubprocessTest.eventSubprocModel(this.builder);
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_start").withElementType(BpmnElementType.START_EVENT).withProcessInstanceKey(processInstanceKey).await();
        this.triggerEventSubprocess.accept(processInstanceKey);
        long startEventCount = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_start").withElementType(BpmnElementType.START_EVENT).withProcessInstanceKey(processInstanceKey).limit(2L)).count();
        Assertions.assertThat((long)startEventCount).isEqualTo(2L);
    }

    @Test
    public void shouldTriggerEventSubprocessAndCreateLocalScopeVariable() {
        BpmnModelInstance model = NonInterruptingEventSubprocessTest.eventSubprocModelWithLocalScopeVariable(this.builder);
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        Record subProcessActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_proc").withElementType(BpmnElementType.EVENT_SUB_PROCESS).withProcessInstanceKey(processInstanceKey).getFirst();
        NonInterruptingEventSubprocessTest.assertEventSubprocessLifecycle(processInstanceKey);
        RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withName("localScope").withScopeKey(subProcessActivated.getKey()).await();
    }

    @Test
    public void shouldTriggerEventSubprocessTwiceWithOwnLocalScopeVariable() {
        Assume.assumeTrue((boolean)this.cyclic);
        BpmnModelInstance model = NonInterruptingEventSubprocessTest.eventSubprocModelWithLocalScopeVariable(this.builder);
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_start").withElementType(BpmnElementType.START_EVENT).withProcessInstanceKey(processInstanceKey).await();
        this.triggerEventSubprocess.accept(processInstanceKey);
        List eventSubProcessActivatedList = (List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("event_sub_proc").withElementType(BpmnElementType.EVENT_SUB_PROCESS).withProcessInstanceKey(processInstanceKey).limit(2L)).collect(Collectors.toList());
        RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withName("localScope").withScopeKey(((Record)eventSubProcessActivatedList.get(0)).getKey()).await();
        RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withName("localScope").withScopeKey(((Record)eventSubProcessActivatedList.get(1)).getKey()).await();
    }

    @Test
    public void shouldNotInterruptParentProcess() {
        BpmnModelInstance model = NonInterruptingEventSubprocessTest.eventSubprocModel(this.builder);
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        NonInterruptingEventSubprocessTest.assertEventSubprocessLifecycle(processInstanceKey);
        ENGINE.job().ofInstance(processInstanceKey).withType("type").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldInterruptEmbeddedSubProcess() {
        BpmnModelInstance model = NonInterruptingEventSubprocessTest.eventSubprocModelWithEmbeddedSubWithBoundaryEvent(this.builder);
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("embedded_sub_task").await();
        ENGINE.message().withName("bndr").withCorrelationKey(this.correlationKey).publish();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limit(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() == BpmnElementType.EVENT_SUB_PROCESS && r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldNotPropagateVariablesToScope() {
        BpmnModelInstance model = this.eventSubProcTaskModel(this.helper.getJobType(), "sub_type");
        long processInstanceKey = this.createInstanceAndTriggerEvent(model);
        long eventSubprocKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).getFirst()).getKey();
        ENGINE.variables().ofScope(eventSubprocKey).withDocument(Map.of("y", 2)).withUpdateSemantic(VariableDocumentUpdateSemantic.LOCAL).update();
        ENGINE.job().ofInstance(processInstanceKey).withType("sub_type").complete();
        Record<JobBatchRecordValue> job = ENGINE.jobs().withType(this.helper.getJobType()).activate();
        Map jobVariables = ((JobRecordValue)((JobBatchRecordValue)job.getValue()).getJobs().iterator().next()).getVariables();
        Assertions.assertThat((Map)jobVariables).containsOnly(new Map.Entry[]{Map.entry("key", this.correlationKey)});
    }

    private static void assertEventSubprocessLifecycle(long processInstanceKey) {
        List events = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).filter(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().startsWith("event_sub_"))).onlyEvents()).limit(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED && ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() == BpmnElementType.EVENT_SUB_PROCESS)).asList();
        Assertions.assertThat((List)events).extracting(new Function[]{Record::getIntent, e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId()}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, "event_sub_proc"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATED, "event_sub_proc"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, "event_sub_start"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATED, "event_sub_start"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETING, "event_sub_start"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETED, "event_sub_start"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, "event_sub_end"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_ACTIVATED, "event_sub_end"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETING, "event_sub_end"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETED, "event_sub_end"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETING, "event_sub_proc"}), Assertions.tuple((Object[])new Object[]{ProcessInstanceIntent.ELEMENT_COMPLETED, "event_sub_proc"})});
    }

    private long createInstanceAndTriggerEvent(BpmnModelInstance model) {
        this.currentProcess = (ProcessMetadataValue)((DeploymentRecordValue)ENGINE.deployment().withXmlResource(model).deploy().getValue()).getProcessesMetadata().get(0);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("key", this.correlationKey)).create();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).exists()).describedAs("Expected job to be created", new Object[0])).isTrue();
        this.triggerEventSubprocess.accept(processInstanceKey);
        return processInstanceKey;
    }

    private static BpmnModelInstance eventSubprocModel(Function<StartEventBuilder, StartEventBuilder> startBuilder) {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID);
        startBuilder.apply((StartEventBuilder)builder.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(false)).endEvent("event_sub_end");
        return builder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType("type")).endEvent("end_proc").done();
    }

    private static BpmnModelInstance eventSubprocModelWithLocalScopeVariable(Function<StartEventBuilder, StartEventBuilder> startBuilder) {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID);
        startBuilder.apply((StartEventBuilder)((EventSubProcessBuilder)builder.eventSubProcess("event_sub_proc").zeebeInputExpression("=null", "localScope")).startEvent("event_sub_start").interrupting(false)).endEvent("event_sub_end");
        return builder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType("type")).endEvent("end_proc").done();
    }

    private BpmnModelInstance eventSubProcTaskModel(String procTaskType, String subprocTaskType) {
        ProcessBuilder modelBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID);
        this.builder.apply((StartEventBuilder)modelBuilder.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(false)).serviceTask("event_sub_task", t -> t.zeebeJobType(subprocTaskType)).endEvent("event_sub_end");
        return modelBuilder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType(procTaskType)).endEvent("end_proc").done();
    }

    private static BpmnModelInstance eventSubprocModelWithEmbeddedSubWithBoundaryEvent(Function<StartEventBuilder, StartEventBuilder> startBuilder) {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID);
        startBuilder.apply((StartEventBuilder)builder.eventSubProcess("event_sub_proc").startEvent("event_sub_start").interrupting(false)).subProcess("embedded", s -> s.boundaryEvent("boundary-msg", msg -> ((BoundaryEventBuilder)((BoundaryEventBuilder)msg.message(m -> m.name("bndr").zeebeCorrelationKeyExpression("key"))).cancelActivity(Boolean.valueOf(true))).endEvent("boundary-end"))).embeddedSubProcess().startEvent("embedded_sub_start").serviceTask("embedded_sub_task", t -> t.zeebeJobType("embed")).endEvent("embedded_sub_end").moveToNode("embedded").endEvent("event_sub_end");
        return builder.startEvent("start_proc").serviceTask("task", t -> t.zeebeJobType("type")).endEvent("end_proc").done();
    }
}

