/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.processing.distribution.CommandRedistributor;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.CommandDistributionRecordStream;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.ByteValue;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;

public class MultiPartitionDeploymentLifecycleTest {
    private static final int PARTITION_COUNT = 3;
    private static final String DMN_RESOURCE = "/dmn/decision-table.dmn";
    @Rule
    public final EngineRule engine = EngineRule.multiplePartition(3);
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldTestLifecycle() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldReDistributeAfterRecovery").startEvent().endEvent().done();
        this.engine.deployment().withXmlResource("process.bpmn", modelInstance).deploy();
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().withPartitionId(1)).limit(r -> r.getIntent().equals((Object)CommandDistributionIntent.FINISHED))).extracting(new Function[]{Record::getIntent, Record::getRecordType, r -> r.getValue() instanceof CommandDistributionRecordValue ? ((CommandDistributionRecordValue)r.getValue()).getPartitionId() : r.getPartitionId()}).startsWith((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATE, RecordType.COMMAND, 1}), Assertions.tuple((Object[])new Object[]{ProcessIntent.CREATED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.STARTED, RecordType.EVENT, 1})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 2})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 3})})).endsWith((Object)Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.FINISHED, RecordType.EVENT, 1}), (Object[])new Tuple[0]);
        Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(2)).limit(r -> r.getIntent().equals((Object)DeploymentIntent.CREATED))).collect(Collectors.toList()))).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{DeploymentIntent.CREATE, ProcessIntent.CREATED, DeploymentIntent.CREATED});
        Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(3)).limit(r -> r.getIntent().equals((Object)DeploymentIntent.CREATED))).collect(Collectors.toList()))).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{DeploymentIntent.CREATE, ProcessIntent.CREATED, DeploymentIntent.CREATED});
    }

    @Test
    public void shouldDistributeDmnResources() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).deploy();
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)((CommandDistributionRecordStream)RecordingExporter.commandDistributionRecords().withPartitionId(1)).limit(r -> r.getIntent().equals((Object)CommandDistributionIntent.FINISHED))).describedAs("Has dully distributed the deployment", new Object[0])).extracting(new Function[]{Record::getIntent, Record::getRecordType, r -> ((CommandDistributionRecordValue)r.getValue()).getPartitionId()}).startsWith((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.STARTED, RecordType.EVENT, 1})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 2})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 3})})).endsWith((Object)Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.FINISHED, RecordType.EVENT, 1}), (Object[])new Tuple[0]);
        ((ListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().withPartitionId(2)).limit(r -> r.getIntent().equals((Object)DeploymentIntent.CREATED))).describedAs("Has created DMN resources on partition 2", new Object[0])).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{DeploymentIntent.CREATE, DecisionRequirementsIntent.CREATED, DecisionIntent.CREATED, DeploymentIntent.CREATED});
        ((ListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().withPartitionId(3)).limit(r -> r.getIntent().equals((Object)DeploymentIntent.CREATED))).describedAs("Has created DMN resources on partition 3", new Object[0])).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{DeploymentIntent.CREATE, DecisionRequirementsIntent.CREATED, DecisionIntent.CREATED, DeploymentIntent.CREATED});
        DeploymentRecordValue deploymentCreatedEvent = (DeploymentRecordValue)((Record)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).limit(3L)).getLast()).getValue();
        ((ListAssert)Assertions.assertThat((List)deploymentCreatedEvent.getDecisionRequirementsMetadata()).describedAs("Expect that decision requirements are distributed", new Object[0])).isNotEmpty();
        ((ListAssert)Assertions.assertThat((List)deploymentCreatedEvent.getDecisionsMetadata()).describedAs("Expect that decisions are distributed", new Object[0])).isNotEmpty();
    }

    @Test
    public void shouldRejectCompleteDeploymentDistributionWhenAlreadyCompleted() {
        this.engine.pauseProcessing(2);
        this.engine.pauseProcessing(3);
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"shouldReDistributeAfterRecovery").startEvent().endEvent().done()).expectCreated().deploy();
        ((RecordStream)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(2)).withValueType(ValueType.DEPLOYMENT)).withIntent((Intent)DeploymentIntent.CREATE)).await();
        this.engine.getClock().addTime(CommandRedistributor.COMMAND_REDISTRIBUTION_INTERVAL);
        Awaitility.await().untilAsserted(() -> {
            this.engine.getClock().addTime(CommandRedistributor.COMMAND_REDISTRIBUTION_INTERVAL);
            Assertions.assertThat((Stream)((RecordStream)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(2)).withValueType(ValueType.DEPLOYMENT)).withIntent((Intent)DeploymentIntent.CREATE)).limit(2L)).hasSize(2);
        });
        this.engine.resumeProcessing(2);
        Assertions.assertThat((Stream)RecordingExporter.commandDistributionRecords((CommandDistributionIntent)CommandDistributionIntent.ACKNOWLEDGE).withDistributionPartitionId(2).limit(3L)).extracting(Record::getRecordType).describedAs("Expect second command to be rejected", new Object[0]).containsExactlyInAnyOrder((Object[])new RecordType[]{RecordType.COMMAND, RecordType.COMMAND, RecordType.COMMAND_REJECTION});
    }

    @Test
    public void shouldDeployIfResourceIsLargeButNotTooMuch() {
        Record<DeploymentRecordValue> deployment = this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"PROCESS").startEvent().documentation("x".repeat((int)(ByteValue.ofMegabytes((long)2L) - ByteValue.ofKilobytes((long)2L)))).done()).deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deployment).hasIntent((Intent)DeploymentIntent.CREATED).hasRejectionType(RejectionType.NULL_VAL).hasRejectionReason("");
    }
}

