/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessValidationUtil;
import io.camunda.zeebe.engine.util.JobWorkerElementBuilder;
import io.camunda.zeebe.engine.util.JobWorkerElementBuilderProvider;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeJobWorkerElementBuilder;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.util.function.Consumer;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class JobWorkerElementValidationTest {
    @ParameterizedTest
    @ArgumentsSource(value=JobWorkerElementBuilderProvider.class)
    @DisplayName(value="element with invalid job type expression")
    void invalidJobTypeExpression(JobWorkerElementBuilder elementBuilder) {
        BpmnModelInstance process = this.processWithElement(elementBuilder, element -> element.zeebeJobTypeExpression("invalid!"));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ZeebeTaskDefinition.class, "failed to parse expression 'invalid!'"));
    }

    @ParameterizedTest
    @ArgumentsSource(value=JobWorkerElementBuilderProvider.class)
    @DisplayName(value="element with invalid job retries expression")
    void invalidJobRetriesExpression(JobWorkerElementBuilder elementBuilder) {
        BpmnModelInstance process = this.processWithElement(elementBuilder, element -> ((ZeebeJobWorkerElementBuilder)element.zeebeJobType("task")).zeebeJobRetriesExpression("invalid!"));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ZeebeTaskDefinition.class, "failed to parse expression 'invalid!'"));
    }

    private BpmnModelInstance processWithElement(JobWorkerElementBuilder elementBuilder, Consumer<ZeebeJobWorkerElementBuilder<?>> taskModifier) {
        StartEventBuilder processBuilder = Bpmn.createExecutableProcess((String)"process").startEvent();
        AbstractFlowNodeBuilder<?, ?> jobWorkerElementBuilder = elementBuilder.build((AbstractFlowNodeBuilder<?, ?>)processBuilder, taskModifier);
        return jobWorkerElementBuilder.done();
    }
}

