/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class LinkEventDefinitionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectDeploymentIfCatchLinkEventHaveTheSameLinkName() throws Exception {
        Path path = Paths.get(this.getClass().getResource("/processes/LinkEventTest.testInvalidEventLinkMultipleTarget.bpmn").toURI());
        byte[] resource = Files.readAllBytes(path);
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(resource).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: Process_05x4y1u"})).contains(new CharSequence[]{"ERROR: Multiple intermediate catch link event definitions with the same name 'LinkA' are not allowed."});
    }

    @Test
    public void shouldRejectDeploymentIfNoLinkName() throws Exception {
        BpmnModelInstance processDefinition = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateThrowEvent().link("")).done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: linkEvent"})).contains(new CharSequence[]{"ERROR: Link name must be present and not empty."});
    }

    @Test
    public void shouldRejectDeploymentIfCatchLinkEventAfterEventBasedGateway() throws Exception {
        Path path = Paths.get(this.getClass().getResource("/processes/LinkEventTest.testCatchLinkEventAfterEventBasedGatewayNotAllowed.bpmn").toURI());
        byte[] resource = Files.readAllBytes(path);
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(resource).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: Gateway_"})).contains(new CharSequence[]{"ERROR: Event-based gateway must have at least 2 outgoing sequence flows."})).contains(new CharSequence[]{"ERROR: Event-based gateway must not have an outgoing sequence flow to other elements than message/timer/signal intermediate catch events."});
    }

    @Test
    public void shouldAcceptDeploymentValidEventLink() throws Exception {
        Path path = Paths.get(this.getClass().getResource("/processes/LinkEventTest.testValidEventLink.bpmn").toURI());
        byte[] resource = Files.readAllBytes(path);
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(resource).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Should accept deployment valid event link process", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldAcceptDeploymentValidEventLinkMultipleSources() throws Exception {
        Path path = Paths.get(this.getClass().getResource("/processes/LinkEventTest.testEventLinkMultipleSources.bpmn").toURI());
        byte[] resource = Files.readAllBytes(path);
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(resource).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Should accept deployment valid event link multiple sources process", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldExecuteValidEventLink() throws Exception {
        Path path = Paths.get(this.getClass().getResource("/processes/LinkEventTest.testValidEventLink.bpmn").toURI());
        byte[] resource = Files.readAllBytes(path);
        ENGINE.deployment().withXmlResource(resource).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("Process_05x4y1u").create();
        List processInstanceEvents = RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processInstanceEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), Record::getIntent}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"Process_05x4y1u", ProcessInstanceIntent.COMPLETE_ELEMENT})});
    }

    @Test
    public void shouldRejectDeploymentIfLinkEventNotAppearInPairs() {
        BpmnModelInstance processDefinition = LinkEventDefinitionTest.getLinkEventProcess();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: process"})).contains(new CharSequence[]{"ERROR: Can't find an catch link event for the throw link event with the name 'LinkA'."});
    }

    @Test
    public void shouldRejectDeploymentIfTheLinkCatchEventOfLinkThrowEventIsNotInTheSameScope() {
        BpmnModelInstance process = Bpmn.createExecutableProcess().startEvent().subProcess("sub-1", s -> s.embeddedSubProcess().startEvent().intermediateThrowEvent("throw_a").link("link_a")).subProcess("sub-2", s -> {
            s.embeddedSubProcess().startEvent().exclusiveGateway("gateway").intermediateThrowEvent("throw_b").link("link_b");
            s.embeddedSubProcess().intermediateCatchEvent("catch_a", i -> i.link("link_a")).connectTo("gateway");
        }).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(process).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"ERROR: Can't find an catch link event for the throw link event with the name 'link_a'."});
    }

    @Test
    public void shouldRejectDeploymentIfMultipleLinkCatchEventsHaveSameNameInDifferentScopes() {
        BpmnModelInstance process = Bpmn.createExecutableProcess().startEvent().subProcess("sub-1", s -> {
            s.embeddedSubProcess().startEvent().endEvent();
            s.embeddedSubProcess().intermediateCatchEvent("sub_1_catch", i -> i.link("link"));
        }).subProcess("sub-2", s -> {
            s.embeddedSubProcess().startEvent().endEvent();
            s.embeddedSubProcess().intermediateCatchEvent("sub_2_catch", i -> i.link("link"));
        }).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(process).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"ERROR: Multiple intermediate catch link event definitions with the same name 'link' are not allowed."});
    }

    @Test
    public void shouldRejectDeploymentIfThereIsNoCatchEventInTheSameScope() throws Exception {
        Path path = Paths.get(this.getClass().getResource("/processes/invalid_link_event_subprocess.bpmn").toURI());
        byte[] resource = Files.readAllBytes(path);
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(resource).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: process"})).contains(new CharSequence[]{"ERROR: Can't find an catch link event for the throw link event with the name 'foo'"});
    }

    public static BpmnModelInstance getLinkEventProcess() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)"process");
        process.startEvent().manualTask("manualTask1").intermediateThrowEvent().link("LinkA");
        return ((IntermediateCatchEventBuilder)process.linkCatchEvent().link("LinkB")).manualTask("manualTask2").endEvent().done();
    }
}

