/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ZeebeUserTaskPropertiesBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class UserTaskIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TASK_ELEMENT_ID = "user-task";
    @Rule
    public final RecordingExporterTestWatcher watcher = new RecordingExporterTestWatcher();

    private BpmnModelInstance processWithUserTask(Consumer<ZeebeUserTaskPropertiesBuilder<?>> modifier) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask(TASK_ELEMENT_ID, modifier::accept).endEvent().done();
    }

    private IncidentRecordValueAssert assertIncidentCreated(long processInstanceKey, long elementInstanceKey) {
        return this.assertIncidentCreated(processInstanceKey, elementInstanceKey, "<default>");
    }

    private IncidentRecordValueAssert assertIncidentCreated(long processInstanceKey, long elementInstanceKey, String tenantId) {
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        return io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(elementInstanceKey).hasJobKey(-1L).hasVariableScopeKey(elementInstanceKey).hasTenantId(tenantId);
    }

    @Test
    public void shouldCreateIncidentIfAssigneeExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeAssigneeExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Assertion failure on evaluate the expression 'assert(MISSING_VAR, MISSING_VAR != null)': The condition is not fulfilled The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[ASSERT_FAILURE] The condition is not fulfilled");
    }

    @Test
    public void shouldCreateIncidentIfAssigneeExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeAssigneeExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be 'STRING', but was 'ARRAY'.");
    }

    @Test
    public void shouldResolveIncidentAndCreateNewIncidentWhenContinuationFails() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeAssigneeExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withRecordKey(incidentCreated.getKey())).exists()).describedAs("original incident is resolved", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(i -> i.getKey() != incidentCreated.getKey())).exists()).describedAs("a new incident is created", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterAssigneeExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeAssigneeExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", (Object)"no longer missing")})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfCandidateGroupsExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateGroupsExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Assertion failure on evaluate the expression 'assert(MISSING_VAR, MISSING_VAR != null)': The condition is not fulfilled The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[ASSERT_FAILURE] The condition is not fulfilled");
    }

    @Test
    public void shouldCreateIncidentIfCandidateGroupsExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateGroupsExpression("\"not a list\""))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '\"not a list\"' to be 'ARRAY', but was 'STRING'.");
    }

    @Test
    public void shouldCreateIncidentIfCandidateGroupsExpressionOfInvalidArrayItemType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateGroupsExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item.");
    }

    @Test
    public void shouldResolveIncidentAfterCandidateGroupsExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeCandidateGroupsExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", List.of("a string value", "and another"))})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfCandidateUsersExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateUsersExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Assertion failure on evaluate the expression 'assert(MISSING_VAR, MISSING_VAR != null)': The condition is not fulfilled The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[ASSERT_FAILURE] The condition is not fulfilled");
    }

    @Test
    public void shouldCreateIncidentIfCandidateUsersExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateUsersExpression("\"not a list\""))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '\"not a list\"' to be 'ARRAY', but was 'STRING'.");
    }

    @Test
    public void shouldCreateIncidentIfCandidateUsersExpressionOfInvalidArrayItemType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateUsersExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item.");
    }

    @Test
    public void shouldResolveIncidentAfterCandidateUsersExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeCandidateUsersExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", List.of("a string value", "and another"))})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfDueDateExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeDueDateExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Assertion failure on evaluate the expression 'assert(MISSING_VAR, MISSING_VAR != null)': The condition is not fulfilled The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[ASSERT_FAILURE] The condition is not fulfilled");
    }

    @Test
    public void shouldCreateIncidentIfDueDateExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeDueDateExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be one of '[NULL, DATE_TIME, STRING]', but was 'ARRAY'.");
    }

    @Test
    public void shouldResolveIncidentAndCreateNewIncidentWhenContinuationFailsOnDueDate() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeDueDateExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withRecordKey(incidentCreated.getKey())).exists()).describedAs("original incident is resolved", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(i -> i.getKey() != incidentCreated.getKey())).exists()).describedAs("a new incident is created", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterDueDateExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeDueDateExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", (Object)"2023-02-28T10:39:23+02:00")})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfFollowUpDateExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeFollowUpDateExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Assertion failure on evaluate the expression 'assert(MISSING_VAR, MISSING_VAR != null)': The condition is not fulfilled The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[NO_VARIABLE_FOUND] No variable found with name 'MISSING_VAR'\n[ASSERT_FAILURE] The condition is not fulfilled");
    }

    @Test
    public void shouldCreateIncidentIfFollowUpDateExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeFollowUpDateExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be one of '[NULL, DATE_TIME, STRING]', but was 'ARRAY'.");
    }

    @Test
    public void shouldCreateIncidentOnUserTaskForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeFollowUpDateExpression("[1,2,3]"))).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).withTenantId("acme").getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey(), "acme");
    }

    @Test
    public void shouldResolveIncidentAndCreateNewIncidentWhenContinuationFailsOnFollowUpDate() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeFollowUpDateExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withRecordKey(incidentCreated.getKey())).exists()).describedAs("original incident is resolved", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(i -> i.getKey() != incidentCreated.getKey())).exists()).describedAs("a new incident is created", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterFollowUpDateExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeFollowUpDateExpression("assert(MISSING_VAR, MISSING_VAR != null)"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", (Object)"2023-02-28T10:39:23+02:00")})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }
}

