/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.PublishMessageClient;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class PublishMessageTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private PublishMessageClient messageClient;

    @Before
    public void init() {
        this.messageClient = ENGINE_RULE.message().withCorrelationKey("order-123").withName("order canceled").withTimeToLive(1000L);
    }

    @Test
    public void shouldPublishMessage() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.publish();
        Assertions.assertThat((long)publishedRecord.getKey()).isEqualTo(publishedRecord.getKey());
        Assertions.assertThat((Map)((MessageRecordValue)publishedRecord.getValue()).getVariables()).isEmpty();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(publishedRecord).hasIntent((Intent)MessageIntent.PUBLISHED).hasRecordType(RecordType.EVENT).hasValueType(ValueType.MESSAGE);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((MessageRecordValue)((MessageRecordValue)publishedRecord.getValue())).hasName("order canceled").hasCorrelationKey("order-123").hasTimeToLive(1000L).hasMessageId("").hasTenantId("<default>");
    }

    @Test
    public void shouldPublishMessageWithVariables() throws Exception {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withVariables("{'foo':'bar'}").publish();
        Assertions.assertThat((Map)((MessageRecordValue)publishedRecord.getValue()).getVariables()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void shouldPublishMessageWithMessageId() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withId("shouldPublishMessageWithMessageId").publish();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((MessageRecordValue)((MessageRecordValue)publishedRecord.getValue())).hasMessageId("shouldPublishMessageWithMessageId");
    }

    @Test
    public void shouldPublishMessageWithZeroTTL() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withTimeToLive(0L).publish();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((MessageRecordValue)((MessageRecordValue)publishedRecord.getValue())).hasTimeToLive(0L);
    }

    @Test
    public void shouldPublishMessageWithNegativeTTL() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withTimeToLive(-1L).publish();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((MessageRecordValue)((MessageRecordValue)publishedRecord.getValue())).hasTimeToLive(-1L);
    }

    @Test
    public void shouldPublishMessageWithTenantId() {
        String tenantId = "tenant-1";
        Record<MessageRecordValue> publishedRecord = this.messageClient.withTenantId("tenant-1").publish();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((MessageRecordValue)((MessageRecordValue)publishedRecord.getValue())).hasTenantId("tenant-1");
    }

    @Test
    public void shouldPublishSecondMessageWithDifferentId() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withId("shouldPublishSecondMessageWithDifferentId").publish();
        Record<MessageRecordValue> secondPublishedRecord = this.messageClient.withId("shouldPublishSecondMessageWithDifferentId-2").publish();
        Assertions.assertThat((long)publishedRecord.getKey()).isLessThan(secondPublishedRecord.getKey());
    }

    @Test
    public void shouldPublishSecondMessageWithDifferentName() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withName("order canceled").publish();
        Record<MessageRecordValue> secondPublishedRecord = this.messageClient.withName("order shipped").publish();
        Assertions.assertThat((long)publishedRecord.getKey()).isLessThan(secondPublishedRecord.getKey());
    }

    @Test
    public void shouldPublishSecondMessageWithDifferentCorrelationKey() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withName("order-123").publish();
        Record<MessageRecordValue> secondPublishedRecord = this.messageClient.withCorrelationKey("order-456").publish();
        Assertions.assertThat((long)publishedRecord.getKey()).isLessThan(secondPublishedRecord.getKey());
    }

    @Test
    public void shouldPublishSameMessageWithEmptyId() {
        Record<MessageRecordValue> publishedRecord = this.messageClient.withName("order canceled").withId("").publish();
        Record<MessageRecordValue> secondPublishedRecord = this.messageClient.withName("order shipped").withId("").publish();
        Assertions.assertThat((long)publishedRecord.getKey()).isLessThan(secondPublishedRecord.getKey());
    }

    @Test
    public void shouldRejectToPublishSameMessageWithId() {
        this.messageClient.withId("shouldRejectToPublishSameMessageWithId").publish();
        Record<MessageRecordValue> rejectedCommand = this.messageClient.withId("shouldRejectToPublishSameMessageWithId").expectRejection().publish();
        Assertions.assertThat((Comparable)rejectedCommand.getRecordType()).isEqualTo((Object)RecordType.COMMAND_REJECTION);
        Assertions.assertThat((Comparable)rejectedCommand.getRejectionType()).isEqualTo((Object)RejectionType.ALREADY_EXISTS);
    }
}

