/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareFormLinkingTest {
    private static final String PROCESS_ID = "processId";
    private static final String FORM_ID = "Form_0w7r08e";
    private static final String TEST_FORM = "/form/test-form-1.form";
    private static final String TENANT = "tenant";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldActivateUserTask() {
        this.engine.deployment().withXmlResource(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().zeebeFormId(FORM_ID)).endEvent().done()).withXmlClasspathResource(TEST_FORM).withTenantId(TENANT).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).limit(2L)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getTenantId()).containsOnly((Object[])new String[]{TENANT});
    }

    @Test
    public void shouldNotActivateUserTask() {
        this.engine.deployment().withXmlResource(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().zeebeFormId(FORM_ID)).endEvent().done()).withTenantId(TENANT).deploy();
        this.engine.deployment().withXmlClasspathResource(TEST_FORM).withTenantId("otherTenant").deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        Assertions.assertThat((Stream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).limit(1L)).extracting(new Function[]{r -> ((IncidentRecordValue)r.getValue()).getErrorType(), r -> ((IncidentRecordValue)r.getValue()).getErrorMessage(), r -> ((IncidentRecordValue)r.getValue()).getTenantId()}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ErrorType.FORM_NOT_FOUND, "Expected to find a form with id '%s', but no form with this id is found, at least a form with this id should be available. To resolve the Incident please deploy a form with the same id".formatted(FORM_ID), TENANT})});
    }
}

