/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class TenantAwareTimerEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher testWatcher = new RecordingExporterTestWatcher();
    private String processId;

    @Before
    public void setup() {
        this.processId = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldCreateTimerForDefaultTenant() {
        Record<DeploymentRecordValue> deployed = ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent("timer-start").timerWithDuration(Duration.ofMinutes(10L))).endEvent().done()).withTenantId("<default>").deploy();
        ((RecordAssert)Assertions.assertThat(deployed).describedAs("Expect that process with timer was deployed successful", new Object[0])).hasIntent((Intent)DeploymentIntent.CREATED);
        ((RecordAssert)Assertions.assertThat((Record)((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deployed.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey()).getFirst())).describedAs("Expect that timer was created", new Object[0])).isNotNull();
    }
}

