/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.groups.Tuple;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CancelProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"PROCESS").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).zeebeJobRetries("5")).endEvent().done();
    private static final BpmnModelInstance PROCESS_USER_TASK = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"PROCESS_USER_TASK").startEvent().userTask("task").zeebeUserTask()).endEvent().done();
    private static final BpmnModelInstance SUB_PROCESS_PROCESS = Bpmn.createExecutableProcess((String)"SUB_PROCESS_PROCESS").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).zeebeJobRetries("5")).endEvent().subProcessDone().endEvent().done();
    private static final BpmnModelInstance FORK_PROCESS;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        ENGINE.deployment().withXmlResource(PROCESS).deploy();
        ENGINE.deployment().withXmlResource(SUB_PROCESS_PROCESS).deploy();
        ENGINE.deployment().withXmlResource(FORK_PROCESS).deploy();
        ENGINE.deployment().withXmlResource(PROCESS_USER_TASK).deploy();
    }

    @Test
    public void shouldCancelProcessInstance() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record processInstanceCanceledEvent = (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withRecordKey(processInstanceKey)).withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED)).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)processInstanceCanceledEvent.getValue())).hasBpmnProcessId("PROCESS").hasVersion(1).hasProcessInstanceKey(processInstanceKey).hasElementId("PROCESS");
        List processEvents = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getIntent() == ProcessInstanceIntent.CANCEL)).limit(r -> r.getKey() == processInstanceKey && r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED)).asList();
        Assertions.assertThat((List)processEvents).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), e -> e.getIntent()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"", ProcessInstanceIntent.CANCEL}), Assertions.tuple((Object[])new Object[]{"PROCESS", ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{"PROCESS", ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldNotCancelElementInstance() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        Record task = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        Record<ProcessInstanceRecordValue> rejectedCancel = ENGINE.processInstance().withInstanceKey(task.getKey()).onPartition(1).expectRejection().cancel();
        Assertions.assertThat((Comparable)rejectedCancel.getRejectionType()).isEqualTo((Object)RejectionType.NOT_FOUND);
        Assertions.assertThat((String)rejectedCancel.getRejectionReason()).isEqualTo("Expected to cancel a process instance with key '" + task.getKey() + "', but no such process was found");
    }

    @Test
    public void shouldCancelProcessInstanceWithEmbeddedSubProcess() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("SUB_PROCESS_PROCESS").create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        List processEvents = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getIntent() == ProcessInstanceIntent.CANCEL)).limitToProcessInstanceTerminated().asList();
        ((ListAssert)Assertions.assertThat((List)processEvents).hasSize(10)).extracting(new Function[]{e -> ((ProcessInstanceRecordValue)e.getValue()).getElementId(), e -> e.getIntent()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"", ProcessInstanceIntent.CANCEL}), Assertions.tuple((Object[])new Object[]{"SUB_PROCESS_PROCESS", ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{"subProcess", ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{"subProcess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.TERMINATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{"subProcess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{"SUB_PROCESS_PROCESS", ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldCancelActivityInstance() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        Record activityActivatedEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record activityTerminatedEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED)).getFirst();
        Assertions.assertThat((long)activityTerminatedEvent.getKey()).isEqualTo(activityActivatedEvent.getKey());
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)activityActivatedEvent.getValue())).hasBpmnProcessId("PROCESS").hasVersion(1).hasProcessInstanceKey(processInstanceKey).hasElementId("task");
    }

    @Test
    public void shouldCancelProcessInstanceWithParallelExecution() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("FORK_PROCESS").create();
        ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).limit(2L)).asList();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        List terminatedElements = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getIntent() == ProcessInstanceIntent.CANCEL)).limitToProcessInstanceTerminated().filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED)).asList();
        Assertions.assertThat((List)terminatedElements).hasSize(3);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)terminatedElements).extracting(Record::getValue).extracting(ProcessInstanceRecordValue::getElementId).containsSubsequence((Object[])new String[]{"task1", "FORK_PROCESS"})).containsSubsequence((Object[])new String[]{"task2", "FORK_PROCESS"})).contains((Object[])new String[]{"task1", "task2", "FORK_PROCESS"});
    }

    @Test
    public void shouldCancelIntermediateCatchEvent() {
        ENGINE.deployment().withXmlResource(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"shouldCancelIntermediateCatchEvent").startEvent().intermediateCatchEvent("catch-event").message(b -> b.name("msg").zeebeCorrelationKeyExpression("id"))).done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldCancelIntermediateCatchEvent").withVariable("id", "123").create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("catch-event").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record terminatedEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("shouldCancelIntermediateCatchEvent").withIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED)).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)terminatedEvent.getValue())).hasBpmnProcessId("shouldCancelIntermediateCatchEvent").hasVersion(1).hasProcessInstanceKey(processInstanceKey).hasElementId("shouldCancelIntermediateCatchEvent");
    }

    @Test
    public void shouldCancelJobForActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        Record jobCreatedEvent = (Record)((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record terminateActivity = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.TERMINATE_ELEMENT)).getFirst();
        Record jobCanceledEvent = (Record)((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CANCELED)).getFirst();
        Assertions.assertThat((long)jobCanceledEvent.getKey()).isEqualTo(jobCreatedEvent.getKey());
        JobRecordValue jobCanceledEventValue = (JobRecordValue)jobCanceledEvent.getValue();
        Assertions.assertThat((long)jobCanceledEventValue.getProcessInstanceKey()).isEqualTo(processInstanceKey);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)jobCanceledEventValue).hasElementId("task").hasProcessDefinitionVersion(1).hasBpmnProcessId("PROCESS");
    }

    @Test
    public void shouldCancelUserTaskForActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_USER_TASK").create();
        Record userTaskCreatedEvent = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.TERMINATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        Assertions.assertThat((Stream)RecordingExporter.userTaskRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.CANCELING}), Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.CANCELED})});
        Record userTaskCanceledEvent = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CANCELED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTaskCanceledEvent.getValue())).hasUserTaskKey(userTaskCreatedEvent.getKey()).hasProcessInstanceKey(processInstanceKey).hasElementId("task").hasProcessDefinitionVersion(1).hasBpmnProcessId("PROCESS_USER_TASK");
    }

    @Test
    public void shouldRejectCancelNonExistingProcessInstance() {
        Record<ProcessInstanceRecordValue> rejectedCancel = ENGINE.processInstance().withInstanceKey(-1L).onPartition(1).expectRejection().cancel();
        Assertions.assertThat((Comparable)rejectedCancel.getRecordType()).isEqualTo((Object)RecordType.COMMAND_REJECTION);
        Assertions.assertThat((Comparable)rejectedCancel.getRejectionType()).isEqualTo((Object)RejectionType.NOT_FOUND);
        Assertions.assertThat((String)rejectedCancel.getRejectionReason()).isEqualTo("Expected to cancel a process instance with key '-1', but no such process was found");
        Assertions.assertThat((boolean)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withPosition(rejectedCancel.getSourceRecordPosition())).withIntent((Intent)ProcessInstanceIntent.CANCEL)).exists()).isTrue();
    }

    @Test
    public void shouldRejectCancelCompletedProcessInstance() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"shouldRejectCancelCompletedProcessInstance").startEvent().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("shouldRejectCancelCompletedProcessInstance").create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("shouldRejectCancelCompletedProcessInstance").withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).getFirst();
        Record<ProcessInstanceRecordValue> rejectedCancel = ENGINE.processInstance().withInstanceKey(processInstanceKey).expectRejection().cancel();
        Assertions.assertThat((Comparable)rejectedCancel.getRecordType()).isEqualTo((Object)RecordType.COMMAND_REJECTION);
        Assertions.assertThat((Comparable)rejectedCancel.getRejectionType()).isEqualTo((Object)RejectionType.NOT_FOUND);
        Assertions.assertThat((String)rejectedCancel.getRejectionReason()).isEqualTo("Expected to cancel a process instance with key '" + processInstanceKey + "', but no such process was found");
        Assertions.assertThat((boolean)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withPosition(rejectedCancel.getSourceRecordPosition())).withIntent((Intent)ProcessInstanceIntent.CANCEL)).exists()).isTrue();
    }

    @Test
    public void shouldRejectCancelAlreadyCanceledProcessInstance() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Record<ProcessInstanceRecordValue> rejectedCancel = ENGINE.processInstance().withInstanceKey(processInstanceKey).expectRejection().cancel();
        Assertions.assertThat((Comparable)rejectedCancel.getRecordType()).isEqualTo((Object)RecordType.COMMAND_REJECTION);
        Assertions.assertThat((Comparable)rejectedCancel.getRejectionType()).isEqualTo((Object)RejectionType.NOT_FOUND);
        Assertions.assertThat((String)rejectedCancel.getRejectionReason()).isEqualTo("Expected to cancel a process instance with key '" + processInstanceKey + "', but no such process was found");
    }

    @Test
    public void shouldWriteEntireEventOnCancel() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        Record activatedEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("PROCESS").withProcessInstanceKey(processInstanceKey).getFirst();
        Record<ProcessInstanceRecordValue> canceledRecord = ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Object)((ProcessInstanceRecordValue)canceledRecord.getValue())).isEqualTo((Object)activatedEvent.getValue());
    }

    @Test
    public void shouldCancelJobsWithIncidents() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").create();
        Record<JobRecordValue> job = ENGINE.job().ofInstance(processInstanceKey).withType("test").throwError();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withJobKey(job.getKey()).findAny()).describedAs("Expect an incident on the job", new Object[0])).isPresent();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords().withElementType(BpmnElementType.PROCESS).withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated().findAny()).describedAs("Wait until the process instance has terminated", new Object[0])).isPresent();
        ((OptionalAssert)Assertions.assertThat((Optional)((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CANCELED).withRecordKey(job.getKey())).findAny()).describedAs("Expect that the job is cancelled", new Object[0])).isPresent();
    }

    static {
        AbstractFlowNodeBuilder builder = Bpmn.createExecutableProcess((String)"FORK_PROCESS").startEvent("start").parallelGateway("fork").serviceTask("task1", b -> b.zeebeJobType("type1")).endEvent("end1").moveToNode("fork");
        FORK_PROCESS = builder.serviceTask("task2", b -> b.zeebeJobType("type2")).endEvent("end2").done();
    }
}

