/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.SignalClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.test.util.record.CommandDistributionRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BroadcastSignalMultiplePartitionsTest {
    public static final String PROCESS_ID = "process";
    public static final int PARTITION_COUNT = 3;
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.multiplePartition(3);
    private static final String SIGNAL_NAME = "a";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final SignalClient signalClient = ENGINE.signal().withSignalName("a");

    @Test
    public void shouldWriteDistributingRecordsForOtherPartitions() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().signal(SIGNAL_NAME)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long signalKey = this.signalClient.broadcast().getKey();
        List commandDistributionRecords = ((CommandDistributionRecordStream)((CommandDistributionRecordStream)((CommandDistributionRecordStream)RecordingExporter.commandDistributionRecords().withIntent((Intent)CommandDistributionIntent.DISTRIBUTING)).valueFilter(v -> v.getValueType().equals((Object)ValueType.SIGNAL))).limit(2L)).asList();
        Assertions.assertThat((List)commandDistributionRecords).extracting(Record::getKey).containsOnly((Object[])new Long[]{signalKey});
        Assertions.assertThat((List)commandDistributionRecords).extracting(Record::getValue).extracting(CommandDistributionRecordValue::getPartitionId).containsExactly((Object[])new Integer[]{2, 3});
    }

    @Test
    public void shouldTriggerMultipleSignalCatchEvent() {
        BpmnModelInstance process1 = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"wf_1").startEvent().intermediateCatchEvent("catch1").signal(SIGNAL_NAME)).endEvent().done();
        BpmnModelInstance process2 = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"wf_2").startEvent().intermediateCatchEvent("catch2").signal(SIGNAL_NAME)).endEvent().done();
        ENGINE.deployment().withXmlResource(process1).deploy();
        ENGINE.deployment().withXmlResource(process2).deploy();
        long processInstanceKey1 = ENGINE.processInstance().ofBpmnProcessId("wf_1").create();
        long processInstanceKey2 = ENGINE.processInstance().ofBpmnProcessId("wf_2").create();
        Assertions.assertThat((Stream)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(SIGNAL_NAME).limit(2L)).extracting(record -> ((SignalSubscriptionRecordValue)record.getValue()).getCatchEventId()).containsOnly((Object[])new String[]{"catch1", "catch2"});
        this.signalClient.broadcast();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey1).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"catch1", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"catch1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"wf_1", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"wf_1", ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey2).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"catch2", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"catch2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"wf_2", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"wf_2", ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

