/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ConcurrentTimerEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private long processInstanceKey;
    private Record<TimerRecordValue> timerCreated;

    @Before
    public void setup() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("timer", e -> e.timerWithDuration("PT10S")).done()).deploy();
        this.processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        this.timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(this.processInstanceKey).getFirst();
        ENGINE.stop();
    }

    @Test
    public void shouldRejectTriggerCommandIfTimerIsCanceled() {
        ENGINE.writeRecords(RecordToWrite.command().timer(TimerIntent.CANCEL, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()), RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()));
        ENGINE.start();
        Record rejection = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).onlyCommandRejections()).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Assertions.assertThat((Record)rejection).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectTriggerCommandIfTimerIsTriggered() {
        ENGINE.writeRecords(RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()), RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()));
        ENGINE.start();
        Record rejection = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).onlyCommandRejections()).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Assertions.assertThat((Record)rejection).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectCancelCommandIfTimerIsTriggered() {
        ENGINE.writeRecords(RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()), RecordToWrite.command().timer(TimerIntent.CANCEL, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()));
        ENGINE.start();
        Record rejection = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCEL).onlyCommandRejections()).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Assertions.assertThat((Record)rejection).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectTriggerCommandIfElementInstanceIsLeft() {
        Record processActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementType(BpmnElementType.PROCESS).getFirst();
        Record eventActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementType(BpmnElementType.INTERMEDIATE_CATCH_EVENT).getFirst();
        ENGINE.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)processActivated.getValue()).key(processActivated.getKey()), RecordToWrite.event().processInstance(ProcessInstanceIntent.ELEMENT_TERMINATING, (ProcessInstanceRecordValue)processActivated.getValue()).key(processActivated.getKey()).causedBy(0), RecordToWrite.event().processInstance(ProcessInstanceIntent.ELEMENT_TERMINATING, (ProcessInstanceRecordValue)eventActivated.getValue()).key(eventActivated.getKey()).causedBy(1), RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)this.timerCreated.getValue()).key(this.timerCreated.getKey()));
        ENGINE.start();
        Record rejection = (Record)((TimerRecordStream)RecordingExporter.timerRecords().onlyCommandRejections()).withProcessInstanceKey(this.processInstanceKey).getFirst();
        Assertions.assertThat((Record)rejection).hasRejectionType(RejectionType.INVALID_STATE);
    }
}

