/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessExecutionCleanStateTest {
    private static final String PROCESS_ID = "process";
    private static final List<ZbColumnFamilies> IGNORE_NON_EMPTY_COLUMNS = List.of(ZbColumnFamilies.DEFAULT, ZbColumnFamilies.KEY, ZbColumnFamilies.PROCESS_VERSION, ZbColumnFamilies.PROCESS_CACHE, ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, ZbColumnFamilies.PROCESS_CACHE_DIGEST_BY_ID, ZbColumnFamilies.MESSAGE_STATS, ZbColumnFamilies.MIGRATIONS_STATE);
    @Rule
    public EngineRule engineRule = EngineRule.singlePartition();
    private ProcessingState processingState;

    @Before
    public void init() {
        this.processingState = this.engineRule.getProcessingState();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithServiceTask() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        this.engineRule.job().ofInstance(processInstanceKey).withType("test").withVariable("y", 2).complete();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithSubprocess() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subProcess -> ((SubProcessBuilder)((SubProcessBuilder)subProcess.zeebeInputExpression("x", "y")).zeebeOutputExpression("y", "z")).embeddedSubProcess().startEvent().endEvent()).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithMultiInstance() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("items")).zeebeInputElement("item")).zeebeOutputCollection("results")).zeebeOutputElementExpression("result"))).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("items", List.of(Integer.valueOf(1))).create();
        this.engineRule.job().ofInstance(processInstanceKey).withType("test").withVariable("result", 2).complete();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithTimerEvent() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent("timer", e -> e.timerWithDuration("PT0S")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithMessageEvent() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent("message", e -> ((IntermediateCatchEventBuilder)e.message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).zeebeOutputExpression("x", "y")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "key-1").create();
        Duration timeToLive = Duration.ofSeconds(10L);
        this.engineRule.message().withName("message").withCorrelationKey("key-1").withTimeToLive(timeToLive).withVariables(Map.of("x", 1)).publish();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.engineRule.increaseTime(timeToLive.plus(EngineConfiguration.DEFAULT_MESSAGES_TTL_CHECKER_INTERVAL));
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithMessageStartEvent() {
        Record<DeploymentRecordValue> deployment = this.engineRule.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).zeebeOutputExpression("x", "y")).endEvent().done()).deploy();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        Duration timeToLive = Duration.ofSeconds(10L);
        Record<MessageRecordValue> messagePublished = this.engineRule.message().withName("message").withCorrelationKey("key-1").withTimeToLive(timeToLive).withVariables(Map.of("x", 1)).publish();
        long processInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessDefinitionKey(processDefinitionKey).withElementType(BpmnElementType.PROCESS).getFirst()).getKey();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.engineRule.increaseTime(timeToLive.plus(EngineConfiguration.DEFAULT_MESSAGES_TTL_CHECKER_INTERVAL));
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done()).deploy();
        RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.DELETED).withProcessDefinitionKey(processDefinitionKey).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithErrorEvent() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).boundaryEvent("error", b -> b.error("ERROR")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        this.engineRule.job().ofInstance(processInstanceKey).withType("test").withErrorCode("ERROR").throwError();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithIncident() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        this.engineRule.job().ofInstance(processInstanceKey).withType("test").withRetries(0).fail();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engineRule.job().withKey(((IncidentRecordValue)incidentCreated.getValue()).getJobKey()).withRetries(1).updateRetries();
        this.engineRule.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        this.engineRule.job().ofInstance(processInstanceKey).withType("test").withVariable("y", 2).complete();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithExclusiveGateway() {
        this.engineRule.deployment().withXmlResource(((AbstractGatewayBuilder)((AbstractGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().exclusiveGateway().sequenceFlowId("s1")).conditionExpression("x > 10")).endEvent().moveToLastGateway().sequenceFlowId("s2")).conditionExpression("x <= 10")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithParallelGateway() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").endEvent().moveToNode("fork").endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithEventBasedGateway() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().eventBasedGateway().intermediateCatchEvent("timer", e -> e.timerWithDuration("PT0S")).endEvent().moveToLastGateway().intermediateCatchEvent("message", e -> e.message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "key-1").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithEventSubprocess() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-subprocess", subprocess -> ((StartEventBuilder)((StartEventBuilder)subprocess.startEvent().interrupting(true)).timerWithDuration("PT0.1S")).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithCallActivity() {
        BpmnModelInstance childProcess = Bpmn.createExecutableProcess((String)"child").startEvent().endEvent().done();
        BpmnModelInstance parentProcess = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("call", c -> c.zeebeProcessId("child")).endEvent().done();
        this.engineRule.deployment().withXmlResource("child.bpmn", childProcess).withXmlResource("parent.bpmn", parentProcess).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessCreatedWithResult() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).withResult().create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessCanceled() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("x", 1).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        this.engineRule.processInstance().withInstanceKey(processInstanceKey).cancel();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithTimerStartEvent() {
        Record<DeploymentRecordValue> deployment = this.engineRule.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().timerWithCycle("R/PT10S")).endEvent().done()).deploy();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done()).deploy();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(processDefinitionKey).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithMessageStartEventAndRedeployWithout() {
        Record<DeploymentRecordValue> deployment = this.engineRule.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().message(m -> m.name("msg").zeebeCorrelationKey("=123"))).endEvent().done()).deploy();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done()).deploy();
        RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.DELETED).withProcessDefinitionKey(processDefinitionKey).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithTriggerTimerStartEvent() {
        Record<DeploymentRecordValue> deployment = this.engineRule.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().timerWithDate("=now() + duration(\"PT15S\")")).endEvent().done()).deploy();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engineRule.awaitProcessingOf((Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).getFirst());
        this.engineRule.increaseTime(Duration.ofSeconds(15L));
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessDefinitionKey(processDefinitionKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testProcessWithTimerStartEventRedeployment() {
        Record<DeploymentRecordValue> deployment = this.engineRule.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().timerWithCycle("R/PT10S")).endEvent().done()).deploy();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        Record<DeploymentRecordValue> deploy2 = this.engineRule.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().timerWithCycle("R/PT5S")).endEvent().done()).deploy();
        long processDefinitionKey2 = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done()).deploy();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(processDefinitionKey).await();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(processDefinitionKey2).await();
        this.assertThatStateIsEmpty();
    }

    @Test
    public void testTerminatingProcessWithServiceTask() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).deploy();
        long processInstanceKey = this.engineRule.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.engineRule.job().ofInstance(processInstanceKey).withType("test").withRetries(0).fail();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        this.engineRule.processInstance().withInstanceKey(processInstanceKey).cancel();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertThatStateIsEmpty();
    }

    private void assertThatStateIsEmpty() {
        Awaitility.await().untilAsserted(() -> {
            List nonEmptyColumns = Arrays.stream(ZbColumnFamilies.values()).filter(Predicate.not(IGNORE_NON_EMPTY_COLUMNS::contains)).filter(Predicate.not(arg_0 -> ((ProcessingState)this.processingState).isEmpty(arg_0))).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(nonEmptyColumns).describedAs("Expected all columns to be empty", new Object[0])).isEmpty();
        });
    }
}

