/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class FormStateTest {
    private final String tenantId = "<default>";
    private MutableProcessingState processingState;
    private MutableFormState formState;

    @BeforeEach
    public void setup() {
        this.formState = this.processingState.getFormState();
    }

    @Test
    void shouldReturnEmptyIfNoFormIsDeployedForFormId() {
        Optional persistedForm = this.formState.findLatestFormById(BufferUtil.wrapString((String)"form-1"), "<default>");
        Assertions.assertThat((Optional)persistedForm).isEmpty();
    }

    @Test
    void shouldReturnEmptyIfNoFormIsDeployedForFormKey() {
        Optional persistedForm = this.formState.findFormByKey(1L, "<default>");
        Assertions.assertThat((Optional)persistedForm).isEmpty();
    }
}

