/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_3;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.DbElementInstanceState;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.migration.TemporaryVariableMigration;
import io.camunda.zeebe.engine.state.migration.to_1_3.LegacyDbTemporaryVariablesState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.variable.DbVariableState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TemporaryVariableMigrationTest {
    private static final long EVENT_SCOPE_KEY = 100L;
    private static final DirectBuffer VARIABLES = BufferUtil.wrapString((String)"variable");
    final TemporaryVariableMigration sutMigration = new TemporaryVariableMigration();

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    public class BlackboxTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyDbTemporaryVariablesState legacyTemporaryVariablesState;
        private DbVariableState variableState;
        private DbElementInstanceState elementInstanceState;

        @BeforeEach
        public void setUp() {
            this.legacyTemporaryVariablesState = new LegacyDbTemporaryVariablesState(this.zeebeDb, this.transactionContext);
            this.legacyTemporaryVariablesState.put(100L, VARIABLES);
            this.variableState = new DbVariableState(this.zeebeDb, this.transactionContext);
            this.elementInstanceState = new DbElementInstanceState(this.zeebeDb, this.transactionContext, (MutableVariableState)this.variableState);
        }

        @Test
        public void migrationNeedsToRun() {
            boolean actual = TemporaryVariableMigrationTest.this.sutMigration.needsToRun((ProcessingState)this.processingState);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).describedAs("Migration should run", new Object[0])).isTrue();
            Assertions.assertThat((boolean)this.legacyTemporaryVariablesState.isEmpty()).isFalse();
        }

        @Test
        public void afterMigrationRunNoFurtherMigrationIsNeeded() {
            TemporaryVariableMigrationTest.this.sutMigration.runMigration(this.processingState);
            boolean actual = TemporaryVariableMigrationTest.this.sutMigration.needsToRun((ProcessingState)this.processingState);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).describedAs("Migration should run", new Object[0])).isFalse();
            Assertions.assertThat((boolean)this.legacyTemporaryVariablesState.isEmpty()).isTrue();
            EventTrigger eventTrigger = this.processingState.getEventScopeInstanceState().peekEventTrigger(100L);
            Assertions.assertThat((Comparable)eventTrigger.getVariables()).isEqualTo((Object)VARIABLES);
            Assertions.assertThat((long)eventTrigger.getEventKey()).isEqualTo(-1L);
            Assertions.assertThat((Comparable)eventTrigger.getElementId()).isEqualTo((Object)BufferUtil.wrapString((String)String.format("migrated-variable-%d", 100L)));
        }

        @Test
        public void eventSubProcessGetsMigratedCorrectly() {
            long flowScopeKey = 200L;
            ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
            processInstanceRecord.setBpmnElementType(BpmnElementType.EVENT_SUB_PROCESS);
            processInstanceRecord.setFlowScopeKey(200L);
            this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
            TemporaryVariableMigrationTest.this.sutMigration.runMigration(this.processingState);
            EventTrigger oldEventTrigger = this.processingState.getEventScopeInstanceState().peekEventTrigger(100L);
            EventTrigger newEventTrigger = this.processingState.getEventScopeInstanceState().peekEventTrigger(200L);
            Assertions.assertThat((Object)oldEventTrigger).isNull();
            Assertions.assertThat((Object)newEventTrigger).isNotNull();
            Assertions.assertThat((long)newEventTrigger.getEventKey()).isEqualTo(-1L);
            Assertions.assertThat((Comparable)newEventTrigger.getElementId()).isEqualTo((Object)BufferUtil.wrapString((String)String.format("migrated-variable-%d", 100L)));
            Assertions.assertThat((boolean)this.legacyTemporaryVariablesState.isEmpty()).isTrue();
        }
    }

    @Nested
    public class MockBasedTests {
        @Test
        public void noMigrationNeededWhenColumnIsEmpty() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.TEMPORARY_VARIABLE_STORE)).thenReturn((Object)true);
            boolean actual = TemporaryVariableMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void migrationNeededWhenColumnIsNotEmpty() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.TEMPORARY_VARIABLE_STORE)).thenReturn((Object)false);
            boolean actual = TemporaryVariableMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        @Test
        public void migrationCallsMethodInMigrationState() {
            MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            TemporaryVariableMigrationTest.this.sutMigration.runMigration(mockProcessingState);
            ((MutableMigrationState)Mockito.verify((Object)mockProcessingState.getMigrationState())).migrateTemporaryVariables(mockProcessingState.getEventScopeInstanceState(), mockProcessingState.getElementInstanceState());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProcessingState.getMigrationState()});
        }
    }
}

