/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_2;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;

public class LegacyDecisionState {
    private final DbLong dbDecisionKey = new DbLong();
    private final PersistedDecision dbPersistedDecision = new PersistedDecision();
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKeyColumnFamily;
    private final DbLong dbDecisionRequirementsKey;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKey;

    public LegacyDecisionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.decisionsByKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISIONS, transactionContext, (DbKey)this.dbDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS, transactionContext, (DbKey)this.dbDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
    }

    public void putDecision(long key, DecisionRecord decision) {
        this.dbDecisionKey.wrapLong(key);
        this.dbPersistedDecision.wrap(decision);
        this.decisionsByKeyColumnFamily.upsert((DbKey)this.dbDecisionKey, (DbValue)this.dbPersistedDecision);
    }

    public void putDecisionRequirements(long key, DecisionRequirementsRecord drg) {
        this.dbDecisionRequirementsKey.wrapLong(key);
        this.dbPersistedDecisionRequirements.wrap(drg);
        this.decisionRequirementsByKey.upsert((DbKey)this.dbDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
    }
}

