/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.migration.to_8_3.ProcessInstanceByProcessDefinitionMigration;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

class ProcessInstanceByProcessDefinitionMigrationTest {
    final ProcessInstanceByProcessDefinitionMigration sut = new ProcessInstanceByProcessDefinitionMigration();

    ProcessInstanceByProcessDefinitionMigrationTest() {
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class ProcessInstanceKeyByProcessDefinitionKeyTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyElementInstanceState legacyState;
        private DbLong elementInstanceKey;
        private ElementInstance elementInstance;
        private ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
        private DbLong processDefinitionKey;
        private DbCompositeKey<DbLong, DbLong> processInstanceKeyByProcessDefinitionKey;
        private ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> processInstanceKeyByProcessDefinitionKeyColumnFamily;

        ProcessInstanceKeyByProcessDefinitionKeyTest() {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyElementInstanceState(this.zeebeDb, this.transactionContext);
            this.elementInstanceKey = new DbLong();
            this.elementInstance = new ElementInstance();
            this.elementInstanceColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, this.transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.elementInstance);
            this.processDefinitionKey = new DbLong();
            this.processInstanceKeyByProcessDefinitionKey = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.elementInstanceKey);
            this.processInstanceKeyByProcessDefinitionKeyColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_INSTANCE_KEY_BY_DEFINITION_KEY, this.transactionContext, this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
        }

        @Test
        void shouldInsertIntoProcessInstanceByProcessDefinition() {
            long processInstanceKey = 100L;
            long processDefinitionKey = 101L;
            this.legacyState.insertElementInstance(100L, this.createElementInstance(100L, 101L, BpmnElementType.PROCESS));
            ProcessInstanceByProcessDefinitionMigrationTest.this.sut.runMigration(this.processingState);
            this.elementInstanceKey.wrapLong(100L);
            this.processDefinitionKey.wrapLong(101L);
            Assertions.assertThat((boolean)this.processInstanceKeyByProcessDefinitionKeyColumnFamily.exists(this.processInstanceKeyByProcessDefinitionKey)).isTrue();
        }

        @Test
        void shouldNotMigrateElementInstancesOfTypeOtherThanProcess() {
            long elementInstanceKey = 100L;
            long processInstanceKey = 101L;
            long processDefinitionKey = 102L;
            this.legacyState.insertElementInstance(101L, this.createElementInstance(101L, 102L, BpmnElementType.PROCESS));
            this.legacyState.insertElementInstance(100L, this.createElementInstance(100L, 102L, BpmnElementType.START_EVENT));
            ProcessInstanceByProcessDefinitionMigrationTest.this.sut.runMigration(this.processingState);
            this.elementInstanceKey.wrapLong(100L);
            this.processDefinitionKey.wrapLong(102L);
            Assertions.assertThat((boolean)this.processInstanceKeyByProcessDefinitionKeyColumnFamily.exists(this.processInstanceKeyByProcessDefinitionKey)).isFalse();
        }

        @Test
        void migrationNeededWhenPIByDefinitionIsEmpty() {
            boolean actual = ProcessInstanceByProcessDefinitionMigrationTest.this.sut.needsToRun((ProcessingState)this.processingState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        @Test
        void noMigrationNeededWhenPIByDefinitionIsNotEmptyAndCountIsEqual() {
            long processInstanceKey = 100L;
            long processDefinitionKey = 101L;
            this.elementInstanceKey.wrapLong(100L);
            this.processDefinitionKey.wrapLong(101L);
            this.processInstanceKeyByProcessDefinitionKeyColumnFamily.insert(this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
            this.legacyState.insertElementInstance(100L, this.createElementInstance(100L, 101L, BpmnElementType.PROCESS));
            boolean actual = ProcessInstanceByProcessDefinitionMigrationTest.this.sut.needsToRun((ProcessingState)this.processingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        void migrationNeededWhenPIByDefinitionIsNotEmptyAndCountIsNotEqual() {
            long processInstanceKey = 100L;
            long processDefinitionKey = 101L;
            this.elementInstanceKey.wrapLong(100L);
            this.processDefinitionKey.wrapLong(101L);
            this.processInstanceKeyByProcessDefinitionKeyColumnFamily.insert(this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
            this.legacyState.insertElementInstance(100L, this.createElementInstance(100L, 101L, BpmnElementType.PROCESS));
            this.legacyState.insertElementInstance(102L, this.createElementInstance(102L, 101L, BpmnElementType.PROCESS));
            boolean actual = ProcessInstanceByProcessDefinitionMigrationTest.this.sut.needsToRun((ProcessingState)this.processingState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        private ElementInstance createElementInstance(long elementInstanceKey, long processDefinitionKey, BpmnElementType elementType) {
            ElementInstance parent = elementType == BpmnElementType.PROCESS ? null : this.createElementInstance(elementInstanceKey + 1L, processDefinitionKey, BpmnElementType.PROCESS);
            ProcessInstanceRecord value = new ProcessInstanceRecord().setProcessDefinitionKey(processDefinitionKey).setBpmnElementType(elementType);
            return new ElementInstance(elementInstanceKey, parent, ProcessInstanceIntent.ELEMENT_ACTIVATED, value);
        }
    }

    private static final class LegacyElementInstanceState {
        private final DbLong elementInstanceKey = new DbLong();
        private final ElementInstance elementInstance = new ElementInstance();
        private final ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
        private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> parentChildColumnFamily;
        private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> parentChildKey;
        private final DbForeignKey<DbLong> parentKey;

        public LegacyElementInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.elementInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.elementInstance);
            this.parentKey = new DbForeignKey((DbKey)new DbLong(), (Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, DbForeignKey.MatchType.Full, k -> k.getValue() == -1L);
            this.parentChildKey = new DbCompositeKey(this.parentKey, (DbKey)new DbForeignKey((DbKey)this.elementInstanceKey, (Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY));
            this.parentChildColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_PARENT_CHILD, transactionContext, this.parentChildKey, (DbValue)DbNil.INSTANCE);
        }

        public void insertElementInstance(long key, ElementInstance elementInstance) {
            this.elementInstanceKey.wrapLong(key);
            this.elementInstanceColumnFamily.insert((DbKey)this.elementInstanceKey, (DbValue)elementInstance);
            ((DbLong)this.parentKey.inner()).wrapLong(elementInstance.getParentKey());
            this.parentChildColumnFamily.insert(this.parentChildKey, (DbValue)DbNil.INSTANCE);
        }
    }
}

